/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.tag;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagService;
import com.qiho.manager.biz.service.tag.TagService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.tag.TagVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
implements TagService {
    @Autowired
    private RemoteTagService remoteTagService;

    @Override
    public Boolean save(TagDto tagDto) {
        ResultDto result;
        AdminDto adminDto = RequestTool.getAdmin();
        tagDto.setModifier(adminDto.getName());
        if (tagDto != null) {
            tagDto.setCreator(adminDto.getName());
        }
        if (!(result = this.remoteTagService.saveTag(tagDto)).isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean delete(Long id) {
        return this.remoteTagService.delete(id);
    }

    @Override
    public Pagenation<TagVO> queryPage(TagPageParam param) {
        Pagenation<TagVO> page = new Pagenation<TagVO>();
        PagenationDto pagenationDto = this.remoteTagService.queryPage(param);
        page.setTotal(pagenationDto.getTotal());
        if (pagenationDto.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(BeanUtils.copyList((List)pagenationDto.getList(), TagVO.class));
        return page;
    }

    @Override
    public List<TagVO> findByTypeId(Long typeId) {
        List tagDtoList = this.remoteTagService.findByTypeId(typeId);
        return BeanUtils.copyList((List)tagDtoList, TagVO.class);
    }

    @Override
    public List<TagVO> findItemTags(Long itemId) {
        List tagDtoList = this.remoteTagService.findByItemId(itemId);
        return BeanUtils.copyList((List)tagDtoList, TagVO.class);
    }

    @Override
    public Boolean saveItemTag(Long itemId, List<Long> tagIds) {
        ResultDto resultDto = this.remoteTagService.saveItemTag(itemId, tagIds);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }
}

