/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.tag;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.center.api.params.tag.QueryTagTypeParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagTypeService;
import com.qiho.manager.biz.service.tag.TagTypeService;
import com.qiho.manager.biz.vo.CategoryVO;
import com.qiho.manager.biz.vo.tag.TagTypeVO;
import com.qiho.manager.biz.vo.tag.TagVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagTypeServiceImple
implements TagTypeService {
    @Autowired
    private RemoteTagTypeService remoteTagTypeService;

    @Override
    public String saveType(TagTypeDto tagTypeDto, List<Long> categoryIds) {
        ResultDto resultDto;
        String adminName = RequestTool.getAdmin().getName();
        tagTypeDto.setModifier(adminName);
        if (tagTypeDto.getId() == null) {
            tagTypeDto.setCreator(adminName);
        }
        if (!(resultDto = this.remoteTagTypeService.saveTagType(tagTypeDto, categoryIds)).isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public List<TagTypeVO> queryTagType(Long catagoryId, String typeName) {
        QueryTagTypeParam param = new QueryTagTypeParam();
        param.setCategoryId(catagoryId);
        param.setTypeName(typeName);
        List tagTypeDtos = this.remoteTagTypeService.queryTagType(param);
        return BeanUtils.copyList((List)tagTypeDtos, TagTypeVO.class);
    }

    @Override
    public Boolean deleteTagType(Long id) {
        if (id == null) {
            throw new QihoManagerException("\u6807\u7b7e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.remoteTagTypeService.deleteTagType(id);
    }

    @Override
    public List<TagTypeVO> findByItemId(Long itemId) {
        ResultDto result = this.remoteTagTypeService.findByItemId(itemId);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        List tagTypeDtos = (List)result.getResult();
        if (CollectionUtils.isEmpty((Collection)tagTypeDtos)) {
            return Lists.newArrayList();
        }
        ArrayList tagTypeVOList = Lists.newArrayList();
        for (TagTypeDto tagTypeDto : tagTypeDtos) {
            TagTypeVO tagTypeVO = (TagTypeVO)BeanUtils.copy((Object)tagTypeDto, TagTypeVO.class);
            tagTypeVO.setTagList(BeanUtils.copyList((List)tagTypeDto.getTagList(), TagVO.class));
            tagTypeVOList.add(tagTypeVO);
        }
        return tagTypeVOList;
    }

    @Override
    public List<CategoryVO> findCategoryByTypeId(Long typeId) {
        List categoryDtoList = this.remoteTagTypeService.findCategoryByTypeId(typeId);
        return BeanUtils.copyList((List)categoryDtoList, CategoryVO.class);
    }
}

