/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.item;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.remoteservice.item.RemoteItemEvaluateBackendService;
import com.qiho.manager.biz.runnable.AbstractItemEvaluateHandler;
import com.qiho.manager.biz.vo.item.ItemEvaluateDealWithVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.enums.ItemEvaluateSaveFailedEnum;
import com.qiho.manager.common.util.OSSFileService;
import com.qiho.manager.common.util.ReadExcelUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ItemEvaluateDealWithService
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(ItemEvaluateDealWithService.class);
    private static final int MAX_SHOW_LEN = 50;
    private CacheConstantseEnum constantse = CacheConstantseEnum.IMPORT_ITEM_EVALUATES;
    private ApplicationContext applicationContext;
    @Autowired
    private OSSFileService ossFileService;
    @Autowired
    private RemoteItemEvaluateBackendService remoteItemEvaluateBackendService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemEvaluateDealWithVO submitDealWithTask(String fileUrl, Long itemId, Class<? extends AbstractItemEvaluateHandler> handlerClass) {
        ItemEvaluateDealWithVO vo = new ItemEvaluateDealWithVO();
        InputStream input = this.ossFileService.getOssFileInputStream(fileUrl);
        try {
            AbstractItemEvaluateHandler handler;
            List evalList;
            if (Objects.equal(null, (Object)input)) {
                throw new QihoException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String taskId = this.createTaskId();
            String cacheKey = this.constantse.getCacheKey((Object)taskId);
            int count = this.flush(cacheKey, evalList = ReadExcelUtil.createExcel((InputStream)input, (boolean)ReadExcelUtil.isExcel2003((String)fileUrl)), handler = (AbstractItemEvaluateHandler)this.applicationContext.getBean(handlerClass), itemId);
            if (count == ItemEvaluateSaveFailedEnum.EXCESS_MAX_THRESHOLD.getCode()) {
                vo.setCount(ItemEvaluateSaveFailedEnum.EXCESS_MAX_THRESHOLD.getCode());
                ItemEvaluateDealWithVO itemEvaluateDealWithVO = vo;
                return itemEvaluateDealWithVO;
            }
            this.redisTemplate.boundHashOps((Object)cacheKey).put((Object)"count", (Object)String.valueOf(count));
            if (count == 0) {
                this.redisTemplate.boundHashOps((Object)cacheKey).put((Object)"success", (Object)"true");
            }
            this.redisTemplate.expire((Object)cacheKey, 3L, TimeUnit.HOURS);
            vo.setTaskId(taskId);
            vo.setCount(count);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.ossFileService.closeInputStream(input);
        }
        return vo;
    }

    private <T> Integer flush(String cacheKey, List<String> lines, AbstractItemEvaluateHandler<T> handler, Long itemId) {
        if (lines.isEmpty()) {
            return 0;
        }
        Integer evalCount = this.remoteItemEvaluateBackendService.queryItemEvalCount(itemId);
        if (evalCount >= 50) {
            return ItemEvaluateSaveFailedEnum.EXCESS_MAX_THRESHOLD.getCode();
        }
        ArrayList list = Lists.newArrayList();
        for (String line : lines) {
            T params = handler.transform(line, itemId);
            if (params != null) {
                list.add(params);
            }
            if (evalCount + list.size() < 50) continue;
            break;
        }
        int total = 0;
        if (list.isEmpty()) {
            return total;
        }
        total = handler.exeTask(cacheKey, list);
        lines.clear();
        return total;
    }

    private String createTaskId() {
        Long taskId = System.currentTimeMillis();
        String key = this.constantse.getCacheKey((Object)taskId);
        HashMap info = Maps.newHashMap();
        info.put("success", "false");
        info.put("count", "0");
        info.put("successCount", "0");
        info.put("failCount", "0");
        info.put("taskCount", "0");
        info.put("failIds", "");
        this.redisTemplate.opsForHash().putAll((Object)key, (Map)info);
        return taskId.toString();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public JSONObject findImportWithInfo(String taskId) {
        String cacheKey = this.constantse.getCacheKey((Object)taskId);
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)cacheKey);
        JSONObject json = new JSONObject();
        Map info = operations.entries();
        if (info.isEmpty()) {
            json.put("success", (Object)true);
        } else {
            json.putAll(info);
            if (json.getInteger("count") != 0 && json.getInteger("taskCount") == 0) {
                operations.put((Object)"success", (Object)"true");
                this.redisTemplate.delete((Object)taskId);
            }
        }
        json.put("success", (Object)json.getBoolean("success"));
        return json;
    }
}

