/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.item.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.center.api.enums.item.ItemEvaluateTypeEnum;
import com.qiho.center.api.remoteservice.item.RemoteItemEvaluateBackendService;
import com.qiho.manager.biz.service.item.ItemEvaluateService;
import com.qiho.manager.biz.vo.item.ItemEvaluateVO;
import com.qiho.manager.common.enums.ItemEvaluateSaveFailedEnum;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="itemEvaluateService")
public class ItemEvaluateServiceImpl
implements ItemEvaluateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemEvaluateServiceImpl.class);
    private static final int MAX_SHOW_LEN = 50;
    @Resource
    private RemoteItemEvaluateBackendService remoteItemEvaluateBackendService;

    @Override
    public List<ItemEvaluateVO> queryItmeEvalList(Long itemId) {
        List itemEvaluateDtoList = this.remoteItemEvaluateBackendService.queryItmeEvalList(itemId);
        if (CollectionUtils.isEmpty((Collection)itemEvaluateDtoList)) {
            return Lists.newArrayList();
        }
        if (itemEvaluateDtoList.size() > 50) {
            itemEvaluateDtoList = itemEvaluateDtoList.subList(0, 50);
        }
        return BeanUtils.copyList((List)itemEvaluateDtoList, ItemEvaluateVO.class);
    }

    @Override
    public Integer addItemEval(ItemEvaluateDto itemEvaluateDto) {
        int count = this.remoteItemEvaluateBackendService.queryItemEvalCount(itemEvaluateDto.getItemId());
        if (count < 0 || count >= 50) {
            return ItemEvaluateSaveFailedEnum.EXCESS_MAX_THRESHOLD.getCode();
        }
        itemEvaluateDto.setEvaluateType(ItemEvaluateTypeEnum.MANUAL_EVAL.getCode());
        Integer maxSort = this.remoteItemEvaluateBackendService.queryMaxSort(itemEvaluateDto.getItemId());
        itemEvaluateDto.setSort(Integer.valueOf(maxSort == null ? 0 : maxSort + 1));
        return this.remoteItemEvaluateBackendService.addItemEval(itemEvaluateDto);
    }

    @Override
    public Integer updateItemEval(ItemEvaluateDto itemEvaluateDto) {
        return this.remoteItemEvaluateBackendService.updateItemEval(itemEvaluateDto);
    }

    @Override
    public Integer deletedItemEval(Long itemEvalId) {
        return this.remoteItemEvaluateBackendService.deletedItemEval(itemEvalId);
    }

    @Override
    public Integer sortItemEval(Long itemId, List<Long> itemEvalIds) {
        return this.remoteItemEvaluateBackendService.sortItemEval(itemId, itemEvalIds);
    }
}

