/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.merchant.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantAdvertBackendService;
import com.qiho.manager.biz.params.merchant.MerchantAdvertSaveParam;
import com.qiho.manager.biz.service.merchant.MerchantAdvertService;
import com.qiho.manager.biz.vo.SelectVO;
import com.qiho.manager.biz.vo.merchant.MerchantAdvertVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="merchantAdvertService")
public class MerchantAdvertServiceImpl
implements MerchantAdvertService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantAdvertServiceImpl.class);
    @Resource
    private RemoteMerchantAdvertBackendService remoteMerchantAdvertBackendService;

    @Override
    public List<MerchantAdvertVO> listAllAdvert(Long merchantId) {
        List remoteResult;
        try {
            remoteResult = this.remoteMerchantAdvertBackendService.findAll(merchantId);
        }
        catch (Exception e) {
            LOGGER.error("list all advert error:", (Throwable)e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList((List)remoteResult, MerchantAdvertVO.class);
    }

    @Override
    public List<MerchantAdvertVO> listAdvertConsume(Long merchantId, Date dateStart, Date dateEnd) {
        List remoteResult;
        try {
            remoteResult = this.remoteMerchantAdvertBackendService.findAdvertConsume(merchantId, dateStart, dateEnd);
        }
        catch (Exception e2) {
            LOGGER.error("list advert consume error:", (Throwable)e2);
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)remoteResult)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)remoteResult.size());
        remoteResult.forEach(e -> {
            MerchantAdvertVO vo = (MerchantAdvertVO)BeanUtils.copy((Object)e, MerchantAdvertVO.class);
            Long advertConsume = e.getAdvertConsume();
            if (advertConsume != null) {
                vo.setAdvertConsume(new BigDecimal(advertConsume).movePointLeft(2).toString());
            }
            result.add(vo);
        });
        return result;
    }

    @Override
    public List<SelectVO> listUnlinkedAdvert() {
        List remoteResult;
        try {
            remoteResult = this.remoteMerchantAdvertBackendService.findUnLinkedAdvert();
        }
        catch (Exception e) {
            LOGGER.error("list unlinked advert error:", (Throwable)e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList((List)remoteResult, SelectVO.class);
    }

    @Override
    public Boolean saveLink(MerchantAdvertSaveParam saveParam) {
        MerchantAdvertDto saveDto = (MerchantAdvertDto)BeanUtils.copy((Object)saveParam, MerchantAdvertDto.class);
        try {
            return this.remoteMerchantAdvertBackendService.insertMerchantAdvert(saveDto);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("save link advert error:", (Throwable)e);
            throw new QihoManagerException("\u5173\u8054\u5931\u8d25");
        }
    }
}

