/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.merchant.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantUndeliveryBackendService;
import com.qiho.manager.biz.service.merchant.MerchantUndeliveryService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.merchant.MerchantUndeliveryVO;
import com.qiho.manager.biz.vo.merchant.UndeliveryExportVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MerchantUndeliveryServiceImpl
implements MerchantUndeliveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantUndeliveryServiceImpl.class);
    @Resource
    private RemoteMerchantUndeliveryBackendService remoteMerchantUndeliveryBackendService;
    private static final String EXPORT_PATH = "merchant/undelivery/";
    private static final Joiner joiner = Joiner.on((String)",");
    private static final List<String> UNDELIVERY_HEADERS = Arrays.asList("\u5546\u5bb6\u540d\u79f0", "\u5546\u5bb6id", "\u884c\u653f\u533a\u57df\u4ee3\u7801");
    private static final String[] EXPORT_HEADERS = new String[]{"\u5546\u5bb6\u540d\u79f0", "\u5546\u5bb6id", "\u884c\u653f\u533a\u57df\u4ee3\u7801", "\u6dfb\u52a0\u65f6\u95f4"};

    @Override
    public Pagenation<MerchantUndeliveryVO> find4Page(Long merchantId, String regionCode, Integer pageNum, Integer pageSize) {
        PagenationDto pagenationDto;
        Pagenation<MerchantUndeliveryVO> result = new Pagenation<MerchantUndeliveryVO>();
        MerchantUndeliveryQueryParams queryParams = new MerchantUndeliveryQueryParams();
        queryParams.setMerchantId(merchantId);
        queryParams.setRegionCode(regionCode);
        queryParams.setMax(pageSize);
        queryParams.setOffset(Integer.valueOf((pageNum - 1) * pageSize));
        try {
            pagenationDto = this.remoteMerchantUndeliveryBackendService.find4Page(queryParams);
        }
        catch (Exception e) {
            LOGGER.error("find page failed", (Throwable)e);
            return result;
        }
        result.setList(BeanUtils.copyList((List)pagenationDto.getList(), MerchantUndeliveryVO.class));
        result.setTotal(pagenationDto.getTotal());
        return result;
    }

    @Override
    public boolean deleteUndelivery(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return false;
        }
        try {
            return this.remoteMerchantUndeliveryBackendService.deleteByIds(idList);
        }
        catch (Exception e) {
            LOGGER.error("delete undelivery failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void importUndelivery(String encodeType, MultipartFile file) {
        Boolean result;
        CSVParser csvParser = this.parseFile(encodeType, file);
        this.checkHeader(csvParser.getHeaderMap());
        List<MerchantUndeliveryDto> undeliveryDtoList = this.buildUndeliveryDtoList(csvParser);
        if (CollectionUtils.isEmpty(undeliveryDtoList)) {
            throw new QihoManagerException("\u5bfc\u5165\u5b9e\u4f53\u4e3a\u7a7a");
        }
        try {
            result = this.remoteMerchantUndeliveryBackendService.batchInsert(undeliveryDtoList);
        }
        catch (Exception e) {
            LOGGER.error("remote invoke batch insert failed", (Throwable)e);
            throw new QihoManagerException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7");
        }
        if (!result.booleanValue()) {
            throw new QihoManagerException("\u5bfc\u5165\u4e0d\u6210\u529f\u6216\u6570\u636e\u90fd\u5df2\u5b58\u5728");
        }
    }

    @Override
    public UndeliveryExportVO exportUndelivery(Long merchantId, String regionCode, String encodeType, String fileName) {
        UndeliveryExportVO result = new UndeliveryExportVO();
        try {
            File file = new File(Files.createTempDir(), fileName + ".csv");
            CharSink charSink = Files.asCharSink((File)file, (Charset)Charset.forName(encodeType), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.writeLines((Iterable)Lists.newArrayList((Object[])new String[]{joiner.join((Object[])EXPORT_HEADERS)}));
            List<MerchantUndeliveryDto> remoteDtoList = this.fetchExportData(merchantId, regionCode);
            if (CollectionUtils.isNotEmpty(remoteDtoList)) {
                result.setCount(remoteDtoList.size());
                for (MerchantUndeliveryDto dto : remoteDtoList) {
                    Object[] record = new String[]{dto.getMerchantName(), dto.getMerchantId().toString(), dto.getRegionCode(), LocalDateTime.fromDateFields((Date)dto.getGmtCreate()).toString("yyyy-MM-dd HH:mm:ss")};
                    charSink.writeLines((Iterable)Lists.newArrayList((Object[])new String[]{joiner.join(record)}));
                }
            }
            String path = UploadTool.uploadOssNotCDN((File)file, (String)(EXPORT_PATH + fileName + ".csv"), (String)("application/csv;charset=" + encodeType));
            result.setFilePath(path);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new QihoManagerException("\u5bfc\u51fa\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7");
        }
        return result;
    }

    private List<MerchantUndeliveryDto> fetchExportData(Long merchantId, String regionCode) {
        MerchantUndeliveryQueryParams queryParams = new MerchantUndeliveryQueryParams();
        queryParams.setMerchantId(merchantId);
        queryParams.setRegionCode(regionCode);
        queryParams.setOffset(null);
        queryParams.setMax(null);
        try {
            return this.remoteMerchantUndeliveryBackendService.findByParams(queryParams);
        }
        catch (Exception e) {
            LOGGER.error("find by params failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<MerchantUndeliveryDto> buildUndeliveryDtoList(CSVParser csvParser) {
        List recordList;
        try {
            recordList = csvParser.getRecords();
        }
        catch (IOException e) {
            LOGGER.error("csvParser get records failed", (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)recordList.size());
        recordList.forEach(csvRecord -> {
            MerchantUndeliveryDto dto = new MerchantUndeliveryDto();
            List record = IteratorUtils.toList((Iterator)csvRecord.iterator());
            if (CollectionUtils.isNotEmpty((Collection)record) && record.size() >= 3) {
                String merchantName = record.get(0).toString();
                Long merchantId = Long.valueOf(record.get(1).toString());
                String regionCode = record.get(2).toString();
                dto.setMerchantName(merchantName);
                dto.setMerchantId(merchantId);
                dto.setRegionCode(regionCode);
                result.add(dto);
            }
        });
        return result;
    }

    private void checkHeader(Map<String, Integer> headerMap) {
        ArrayList headerList = Lists.newArrayList(headerMap.keySet());
        if (!ListUtils.isEqualList((Collection)headerList, UNDELIVERY_HEADERS)) {
            throw new QihoManagerException("\u5217\u5934\u4e0d\u6b63\u786e");
        }
    }

    private CSVParser parseFile(String encodeType, MultipartFile file) {
        try {
            InputStreamReader isr = new InputStreamReader(file.getInputStream(), encodeType);
            return CSVFormat.EXCEL.withIgnoreEmptyLines().withHeader(new String[0]).parse((Reader)isr);
        }
        catch (IOException e) {
            LOGGER.error("parse file to record failed", (Throwable)e);
            throw new QihoManagerException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
    }
}

