/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.open.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.order.OrderCancelDto;
import com.qiho.center.api.dto.order.OrderConfirmDto;
import com.qiho.center.api.enums.log.OrderLogSubTypeEnum;
import com.qiho.center.api.params.OrderSubTypeParam;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentService;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.params.open.OpenOrderUpdateStatusParam;
import com.qiho.manager.biz.service.open.OpenOrderService;
import com.qiho.manager.common.enums.OpenOrderStatusEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OpenOrderServiceImpl
implements OpenOrderService {
    private Logger LOGGER = LoggerFactory.getLogger(OpenOrderServiceImpl.class);
    @Resource
    private RemoteBaiqiAgentService agentService;
    @Resource
    private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;
    @Resource
    private RemoteOrderService remoteOrderService;
    @Resource
    private RemoteLogisticsService remoteLogisticsService;

    @Override
    public void updateOrderStatus(OpenOrderUpdateStatusParam statusParam) {
        this.updateOrderStatusParamCheck(statusParam);
        if (Objects.equals(OpenOrderStatusEnum.AUDIT_PASS.getStatus(), statusParam.getStatus())) {
            OrderSubTypeParam subTypeParam = new OrderSubTypeParam();
            subTypeParam.setOrderId(statusParam.getOrderId());
            subTypeParam.setSubType(OrderLogSubTypeEnum.AUDIT_PASS.getSubType());
            this.remoteOrderService.recordLog(subTypeParam);
            return;
        }
        if (Objects.equals(OpenOrderStatusEnum.AUDIT_FAIL.getStatus(), statusParam.getStatus())) {
            OrderSubTypeParam subTypeParam = new OrderSubTypeParam();
            subTypeParam.setOrderId(statusParam.getOrderId());
            subTypeParam.setSubType(OrderLogSubTypeEnum.AUDIT_FAIL.getSubType());
            this.remoteOrderService.recordLog(subTypeParam);
            return;
        }
        if (Objects.equals(OpenOrderStatusEnum.SEND_OUT.getStatus(), statusParam.getStatus())) {
            this.confirmOrder(statusParam);
            return;
        }
        if (Objects.equals(OpenOrderStatusEnum.CANCEL_SEND.getStatus(), statusParam.getStatus())) {
            this.cancelOrder(statusParam);
            return;
        }
        if (Objects.equals(OpenOrderStatusEnum.UPDATE_LOGISTICS.getStatus(), statusParam.getStatus())) {
            this.orderUpdate(statusParam);
            return;
        }
        throw new QihoManagerException("\u672a\u77e5\u7684\u8ba2\u5355\u72b6\u6001");
    }

    private void confirmOrder(OpenOrderUpdateStatusParam statusParam) {
        OrderConfirmDto dto = new OrderConfirmDto();
        dto.setOrderId(statusParam.getOrderId());
        dto.setExpress(statusParam.getLogisticsCode());
        dto.setExpressCode(statusParam.getExpressCode());
        try {
            Boolean result = this.remoteOrderService.orderConfirm(dto);
            if (!result.booleanValue()) {
                throw new QihoManagerException("remoteOrderService.orderConfirm fail");
            }
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    private void cancelOrder(OpenOrderUpdateStatusParam statusParam) {
        OrderCancelDto dto = new OrderCancelDto();
        dto.setOrderId(statusParam.getOrderId());
        dto.setRemark(statusParam.getRemark());
        try {
            Boolean result = this.remoteOrderService.orderCancel(dto);
            if (!result.booleanValue()) {
                throw new QihoManagerException("remoteOrderService.orderCancel fail");
            }
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    private void orderUpdate(OpenOrderUpdateStatusParam statusParam) {
        OrderConfirmDto dto = new OrderConfirmDto();
        dto.setOrderId(statusParam.getOrderId());
        dto.setExpress(statusParam.getLogisticsCode());
        dto.setExpressCode(statusParam.getExpressCode());
        try {
            Boolean result = this.remoteOrderService.orderUpdate(dto);
            if (!result.booleanValue()) {
                throw new QihoManagerException("remoteOrderService.orderUpdate fail");
            }
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    private void updateOrderStatusParamCheck(OpenOrderUpdateStatusParam statusParam) {
        LogisticsDto dto;
        Assert.notNull((Object)statusParam, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)statusParam.getAppKey(), (String)"appKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)statusParam.getAppSecret(), (String)"appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)statusParam.getMerchantId(), (String)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)statusParam.getOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)statusParam.getStatus(), (String)"status\u4e0d\u80fd\u4e3a\u7a7a");
        BaiqiAgentDto agentDto = this.remoteBaiqiAgentBackendService.findAgentByMerchantId(statusParam.getMerchantId());
        Assert.notNull((Object)agentDto, (String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        OpenInterfaceDto interfaceDto = this.agentService.findByAgentId(agentDto.getId());
        Assert.notNull((Object)interfaceDto, (String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        Assert.isTrue((interfaceDto.getAppkey().equals(statusParam.getAppKey()) && interfaceDto.getAppsecret().equals(statusParam.getAppSecret()) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        if (StringUtils.isNotBlank((String)statusParam.getLogisticsCode()) && (Objects.isNull(dto = this.remoteLogisticsService.findByCode(statusParam.getLogisticsCode())) || !Objects.equals(dto.getLogisticsName(), statusParam.getLogisticsName()))) {
            throw new QihoManagerException("\u7269\u6d41\u516c\u53f8\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        DubboResult result = this.remoteOrderService.findOrderSnapshot(statusParam.getOrderId());
        if (!result.isSuccess()) {
            this.LOGGER.error("findByOrderId error, orderId = {}, errorCode = {}, errorMsg = {}", new Object[]{statusParam.getOrderId(), result.getReturnCode(), result.getMsg()});
            throw new QihoManagerException("\u7cfb\u7edf\u5f02\u5e38");
        }
        if (Objects.isNull(result.getResult()) || !statusParam.getMerchantId().equals(String.valueOf(((OrderSnapshotDto)result.getResult()).getMerchantId()))) {
            throw new QihoManagerException("\u8be5\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u5bb6");
        }
    }
}

