/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.orderexport.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.center.api.remoteservice.orderexport.RemoteOrderExportTemplateBackendService;
import com.qiho.manager.biz.service.orderexport.OrderExportTemplateService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.orderexport.FieldVO;
import com.qiho.manager.biz.vo.orderexport.OrderExportTemplateVO;
import com.qiho.manager.biz.vo.orderexport.TemplateFieldVO;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderExportTemplateService")
public class OrderExportTemplateServiceImpl
implements OrderExportTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderExportTemplateServiceImpl.class);
    @Resource
    private RemoteOrderExportTemplateBackendService remoteOrderExportTemplateBackendService;

    @Override
    public Pagenation<OrderExportTemplateVO> find4Page(OrderExportTemplateQueryParams param) {
        PagenationDto remoteResult;
        try {
            remoteResult = this.remoteOrderExportTemplateBackendService.find4Page(param);
        }
        catch (Exception e) {
            LOGGER.error("find template page failed", (Throwable)e);
            return new Pagenation<OrderExportTemplateVO>();
        }
        List list = BeanUtils.copyList((List)remoteResult.getList(), OrderExportTemplateVO.class);
        Pagenation<OrderExportTemplateVO> result = new Pagenation<OrderExportTemplateVO>();
        result.setTotal(remoteResult.getTotal());
        result.setList(list);
        return result;
    }

    @Override
    public List<OrderExportTemplateVO> find4Select() {
        List remoteResult;
        try {
            remoteResult = this.remoteOrderExportTemplateBackendService.findTemp4Select();
        }
        catch (Exception e) {
            LOGGER.error("find template fields failed", (Throwable)e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList((List)remoteResult, OrderExportTemplateVO.class);
    }

    @Override
    public Boolean deleteTemplate(Long tempId) {
        try {
            return this.remoteOrderExportTemplateBackendService.deleteById(tempId);
        }
        catch (Exception e) {
            LOGGER.error("delete template failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean saveTemplate(Long tempId, String tempName) {
        try {
            return this.remoteOrderExportTemplateBackendService.save(tempId, tempName);
        }
        catch (Exception e) {
            LOGGER.error("save template failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<TemplateFieldVO> findTempFields(Long tempId) {
        List remoteResult;
        try {
            remoteResult = this.remoteOrderExportTemplateBackendService.findTempFields(tempId);
        }
        catch (Exception e) {
            LOGGER.error("find template fields failed", (Throwable)e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList((List)remoteResult, TemplateFieldVO.class);
    }

    @Override
    public Boolean deleteTempField(Long tempFieldId) {
        try {
            return this.remoteOrderExportTemplateBackendService.deleteTempField(tempFieldId);
        }
        catch (Exception e) {
            LOGGER.error("delete template field failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean saveTempField(TemplateFieldDto templateFieldDto) {
        try {
            return this.remoteOrderExportTemplateBackendService.saveTempField(templateFieldDto);
        }
        catch (Exception e) {
            LOGGER.error("save template field failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public TemplateFieldVO findTempField(Long tempFieldId) {
        TemplateFieldDto remoteResult;
        try {
            remoteResult = this.remoteOrderExportTemplateBackendService.findTempField(tempFieldId);
        }
        catch (Exception e) {
            LOGGER.error("find template field failed", (Throwable)e);
            return null;
        }
        return (TemplateFieldVO)BeanUtils.copy((Object)remoteResult, TemplateFieldVO.class);
    }

    @Override
    public List<FieldVO> selectFields() {
        List remoteResult;
        try {
            remoteResult = this.remoteOrderExportTemplateBackendService.findField4Select();
        }
        catch (Exception e) {
            LOGGER.error("find field for select  failed", (Throwable)e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList((List)remoteResult, FieldVO.class);
    }
}

