/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.page.CollItemDto;
import com.qiho.center.api.dto.page.CollItemSaveDto;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.remoteservice.page.RemoteCollItemBackendService;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.manager.biz.service.ItemService;
import com.qiho.manager.biz.service.page.CollItemService;
import com.qiho.manager.biz.vo.ItemVO;
import com.qiho.manager.biz.vo.page.CollItemVO;
import com.qiho.manager.common.param.SaveCollItemStyleParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="collItemService")
public class CollItemServiceImpl
implements CollItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollItemServiceImpl.class);
    private static final String COLL_ITEM_DEFAULT_SKIN_STYLE = "{\"styleType\" :1,\"styleId\":1}";
    private static final Integer COLL_ITEM_DEFAULT_STATUS = 0;
    @Resource
    private RemoteCollItemBackendService remoteCollItemBackendService;
    @Resource
    private ItemService itemService;

    @Override
    public List<CollItemVO> queryItemListBySort(Long collId) {
        List collItemDtoList = this.remoteCollItemBackendService.queryItemListBySort(collId);
        if (CollectionUtils.isEmpty((Collection)collItemDtoList)) {
            LOGGER.info("\u8981\u67e5\u8be2\u7684\u96c6\u5408\u9875\u5546\u54c1\u5217\u8868\u4e3a\u7a7a, collId={}", (Object)collId);
            return Lists.newArrayList();
        }
        List<Long> collItemIds = this.filterItemByStatus(collItemDtoList);
        if (CollectionUtils.isEmpty((Collection)(collItemDtoList = this.remoteCollItemBackendService.queryItemListBySortWithItemIds(collId, collItemIds)))) {
            LOGGER.info("\u6839\u636e\u96c6\u5408\u9875id\u548c\u5546\u54c1id\u96c6\u5408\u67e5\u8be2\u5230\u7684\u7ed3\u679c\u4e3a\u7a7a, collId={}, collItemIds={}", (Object)collId, collItemIds);
            return Lists.newArrayList();
        }
        int maxLen = 50;
        if (collItemDtoList.size() > maxLen) {
            collItemDtoList = collItemDtoList.subList(0, maxLen);
        }
        return this.transformCollItemVO(collItemDtoList);
    }

    private List<Long> filterItemByStatus(List<CollItemDto> collItemVOList) {
        List<Long> itemIdList = collItemVOList.stream().map(CollItemDto::getId).collect(Collectors.toList());
        List<ItemVO> itemVOList = this.itemService.queryItemsByItemIds(itemIdList);
        ArrayList collItemIds = Lists.newArrayList();
        for (ItemVO itemVO : itemVOList) {
            if (!StringUtils.equals((String)itemVO.getItemStatus(), (String)ItemStatusEnum.STATUS_ON.getCode())) continue;
            collItemIds.add(itemVO.getId());
        }
        return collItemIds;
    }

    private List<CollItemVO> transformCollItemVO(List<CollItemDto> collItemDtoList) {
        ArrayList collItemVOList = Lists.newArrayList();
        collItemDtoList.forEach(collItemDto -> {
            CollItemVO collItemVO = (CollItemVO)BeanUtils.copy((Object)collItemDto, CollItemVO.class);
            collItemVO.setStyleConfig(JSONUtil.strToJSON((String)collItemDto.getStyleConfig()));
            collItemVOList.add(collItemVO);
        });
        return collItemVOList;
    }

    @Override
    public Integer addCollItemList(Long collId, List<Long> itemIdList) {
        Integer maxSort;
        int maxLen;
        int size = this.remoteCollItemBackendService.queryItemListBySort(collId).size();
        if (size > (maxLen = 50)) {
            return 0;
        }
        if (size + itemIdList.size() > maxLen) {
            itemIdList = itemIdList.subList(0, maxLen - size);
        }
        if (null == (maxSort = this.remoteCollItemBackendService.findMaxSort(collId))) {
            maxSort = -1;
        }
        ArrayList collItemSaveDtoList = Lists.newArrayList();
        for (Long itemId : itemIdList) {
            CollItemSaveDto collitemsaveDto = new CollItemSaveDto();
            collitemsaveDto.setId(collId);
            collitemsaveDto.setItemId(itemId);
            collitemsaveDto.setCollItemStatus(COLL_ITEM_DEFAULT_STATUS);
            collitemsaveDto.setStyleConfig(COLL_ITEM_DEFAULT_SKIN_STYLE);
            maxSort = maxSort + 1;
            collitemsaveDto.setSort(maxSort);
            collItemSaveDtoList.add(collitemsaveDto);
        }
        return this.remoteCollItemBackendService.addCollItemList((List)collItemSaveDtoList);
    }

    @Override
    public Integer deleted4Phy(Long collId, Long itemId) {
        return this.remoteCollItemBackendService.deleted4Phy(collId, itemId);
    }

    @Override
    public Integer sort(Long collId, List<Long> itemIds) {
        return this.remoteCollItemBackendService.sort(collId, itemIds);
    }

    @Override
    public Integer updateStatusBatch(Long collId, List<Long> itemIdList, Integer collItemStatus) {
        return this.remoteCollItemBackendService.updateStatusBatch(collId, itemIdList, collItemStatus);
    }

    @Override
    public Boolean checkStock(List<Long> itemIdList) {
        List<ItemVO> itemVOList = this.itemService.queryItemsByItemIds(itemIdList);
        if (CollectionUtils.isEmpty(itemVOList)) {
            LOGGER.info("\u8981\u67e5\u8be2\u5e93\u5b58\u7684\u96c6\u5408\u9875\u5546\u54c1\u5217\u8868\u4e3a\u7a7a, itemIdList={}", itemIdList);
            return true;
        }
        for (ItemVO itemVO : itemVOList) {
            if (itemVO.getStock() != 0L) continue;
            LOGGER.info("\u5f53\u524d\u96c6\u5408\u9875\u5546\u54c1\u96c6\u5408\u4e2d\u5305\u542b\u5e93\u5b58\u4e3a0\u7684\u5546\u54c1, itemIdList={}", itemIdList);
            return true;
        }
        return false;
    }

    @Override
    public Integer saveStyle(SaveCollItemStyleParam param) {
        JSONObject styleConfigJson = param.getStyleConfig();
        if (!this.isJSON(styleConfigJson.toString()).booleanValue()) {
            LOGGER.info("\u96c6\u5408\u9875\u5546\u54c1\u6837\u5f0f\u683c\u5f0f\u6709\u8bef, param={}", (Object)param);
            return null;
        }
        String styleConfig = styleConfigJson.toString();
        if (StringUtils.equals((String)"0", (String)styleConfigJson.get("styleType").toString())) {
            styleConfig = "";
        }
        CollItemDto collItemDto = this.remoteCollItemBackendService.queryItem(param.getId(), param.getItemId());
        CollItemSaveDto collItemSaveDto = new CollItemSaveDto();
        collItemSaveDto.setItemId(param.getItemId());
        collItemSaveDto.setId(param.getId());
        collItemSaveDto.setStyleConfig(styleConfig);
        collItemSaveDto.setSort(collItemDto.getSort());
        return this.remoteCollItemBackendService.updateCollItemList((List)Lists.newArrayList((Object[])new CollItemSaveDto[]{collItemSaveDto}));
    }

    @Override
    public Integer batchDeleted(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return -1;
        }
        return this.remoteCollItemBackendService.batchDeleted(itemIds);
    }

    private Boolean isJSON(String str) {
        try {
            JSONObject.fromObject((Object)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

