/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.template.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.template.AppWhiteDto;
import com.qiho.center.api.params.template.AppWhitePagingParam;
import com.qiho.center.api.params.template.AppWhiteParam;
import com.qiho.center.api.remoteservice.template.RemoteAppWhiteService;
import com.qiho.manager.biz.service.template.AppWhiteService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.template.TemplateAppWhiteVo;
import com.qiho.manager.common.enums.MessageManagementEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppWhiteServiceImpl
implements AppWhiteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppWhiteServiceImpl.class);
    @Autowired
    private RemoteAppWhiteService remoteAppWhiteService;
    private static final String ALL_SCENE = "ALL";

    @Override
    public boolean save(AppWhiteParam appWhiteParam) {
        AdminDto admin = RequestTool.getAdmin();
        appWhiteParam.setCreator(admin == null ? "" : admin.getName());
        DubboResult dubboResult = this.remoteAppWhiteService.save(appWhiteParam);
        if (!dubboResult.isSuccess()) {
            throw new QihoManagerException(dubboResult.getMsg());
        }
        return dubboResult.isSuccess();
    }

    @Override
    public Pagenation<TemplateAppWhiteVo> pageQuery(AppWhitePagingParam appWhitePagingParam) {
        Pagenation<TemplateAppWhiteVo> pagenation = new Pagenation<TemplateAppWhiteVo>();
        if (ALL_SCENE.equals(appWhitePagingParam.getScene())) {
            appWhitePagingParam.setScene("");
        }
        PagenationDto dtoPagenationDto = this.remoteAppWhiteService.pageQuery(appWhitePagingParam);
        List dtoList = dtoPagenationDto.getList();
        Integer total = dtoPagenationDto.getTotal();
        if (CollectionUtils.isEmpty((Collection)dtoList) || total == null || total <= 0) {
            return pagenation;
        }
        this.buildSceneText(dtoList);
        pagenation.setList(BeanUtils.copyList((List)dtoList, TemplateAppWhiteVo.class));
        pagenation.setTotal(total);
        return pagenation;
    }

    private void buildSceneText(List<AppWhiteDto> dtoList) {
        dtoList.forEach(appWhiteDto -> {
            String scene = appWhiteDto.getScene();
            String desc = MessageManagementEnum.getDescByCode((String)scene);
            appWhiteDto.setScene(desc);
        });
    }

    @Override
    public boolean delete(Long id) {
        if (id == null) {
            throw new QihoManagerException("Param id can not be null");
        }
        boolean delete = this.remoteAppWhiteService.delete(id);
        if (delete) {
            LOGGER.info("App white was deleted id:{},admin:{}", (Object)id, (Object)JSON.toJSONString((Object)RequestTool.getAdmin()));
        }
        return delete;
    }
}

