package com.qiho.manager.biz.mq;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.nio.charset.Charset;

/**
 * 消息生产者
 * Created by sunchangji on 2017/11/23.
 */
@Component
public class QihoMqProducer {

    private static final Logger LOG = LoggerFactory.getLogger(QihoMqProducer.class);

    @Autowired
    private DefaultMQProducer rocketMqProducer;

    /**
     * @param topic
     * @param conent
     * @return boolean
     * @throws Exception
     */
    public boolean sendMqMessage(String topic, String conent) {
        Message msg = new Message(topic, conent.getBytes(Charset.forName("utf-8")));
        // send同步发送消息，只要不抛异常就是成功,send(msg,SendCallback)是异步发送消息
        SendResult sendResult = null;
        try {
            sendResult = rocketMqProducer.send(msg);
        } catch (Exception e) {
            LOG.error("send rocketMq error", e);
            return false;
        }
        return sendResult.isTraceOn();
    }
}
