package com.qiho.manager.biz.params;

import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 更新账户信息对象
 * <p>
 * Created by sunchangji on 2017/12/13.
 */
public class MainAccountUpdateParam {

    @ApiModelProperty("主账号id")
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty("手机号")
    @NotBlank
    private String mobile;

    @ApiModelProperty("密码")
    @NotBlank(message = "密码不能为空")
    private String pwd;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
}
