package com.qiho.manager.biz.params.merchant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * @author peanut.huang
 * @date 2018/1/2.
 */
@ApiModel("商家广告关联保存参数")
public class MerchantAdvertSaveParam {

    /**
     * 商家id
     */
    @ApiModelProperty("商家id")
    @NotNull(message = "商家id为空")
    private Long merchantId;

    /**
     * 广告主id
     */
    @ApiModelProperty("广告主id")
    @NotNull(message = "广告id为空")
    private Long advertId;

    /**
     * 广告主名称
     */
    @ApiModelProperty("广告主名称")
    @NotEmpty(message = "广告名称为空")
    private String advertName;

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }
}
