package com.qiho.manager.biz.params.page;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
@ApiModel("集合页商品保存参数")
public class CollItemSaveParam {

    @ApiModelProperty("集合页页面id")
    @NotEmpty
    private Long id;

    @ApiModelProperty("商品id")
    @NotNull
    private Long itemId;

    @ApiModelProperty("排序值, 数值越大越靠前")
    private Integer sort;

    @ApiModelProperty("商品在当前集合页中的状态, 0-关闭/1-开启")
    private String itemStatus;

    @ApiModelProperty("商品样式配置, skinId或pid的值")
    private JSONObject styleConfig;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public JSONObject getStyleConfig() {
        return styleConfig;
    }

    public void setStyleConfig(JSONObject styleConfig) {
        this.styleConfig = styleConfig;
    }
}
