package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;
import com.qiho.center.api.remoteservice.blackList.RemoteBaiqiBlackListService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * ClassName: BlackListHandler <br/>
 * Function:黑名单批量处理. <br/>
 * date: 2017年6月27日 上午11:51:13 <br/>
 *
 * @author chencheng
 * @version
 */
@Service
public class BlackListHandler implements AbstractOrderHandler<BlackListBatchDealParam> {

    private Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings().limit(3);

    Pattern wirteSpacePattern = Pattern.compile("\\s*|\t|\r|\n");

    @Autowired
    private RemoteBaiqiBlackListService remoteBaiqiBlackListService;

    @Override
    public BlackListBatchDealParam transform(String row, String status) {
        BlackListBatchDealParam params = new BlackListBatchDealParam();
        List<String> list = splitter.splitToList(row);
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank(list.get(0))) {
            return null;
        }

        //手机号
        String value = list.get(0);

        if (value!=null) {
            if (StringUtils.equals(value,"手机号")) {
                return null;
            }
            Matcher matcher = wirteSpacePattern.matcher(value);
            value = matcher.replaceAll("");
        } else {
            return null;
        }

        // 黑名单值
        params.setBkValue(value);
        // 备注
        if (list.size() > 1) {
            params.setRemarks(list.get(1));
        }
        return params;
    }

    @Override
    public BlackListBatchDealParam transform(String row) {
        return transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<BlackListBatchDealParam> list) {
        throw new UnsupportedOperationException("必须指定黑名单类型等其他参数");
    }

    @Override
    public Integer exeTask(String cacheKey, List<BlackListBatchDealParam> list, JSONObject extraParams) {
        Long merchantId = extraParams.getLong("merchantId");
        String name = RequestTool.getAdmin().getName();

        for (BlackListBatchDealParam params : list) {
            params.setMerchantId(merchantId);
            params.setOperator(name);
        }
        return remoteBaiqiBlackListService.batchAddBlackList(cacheKey,list,merchantId,name);
    }


}
