package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by liuyao on 2017/6/14.
 * 批量处理确认发货
 */
@Service
public class ErpOrderDeliverToSuccessHandler implements AbstractOrderHandler<BatchResolveErpDeliverParams> {

    private Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;
    @Resource
    private RemoteLogisticsService remoteLogisticsService;

    @Override
    public BatchResolveErpDeliverParams transform(String row, String status) {
        BatchResolveErpDeliverParams params = new BatchResolveErpDeliverParams();
        List<String> line = splitter.splitToList(row);
        if(line.size()<2){
            return null;
        }
        params.setErpId(line.get(0));
        params.setExpressCode(line.get(1));
        params.setDealResult(BatchResolveErpDeliverParams.DEAL_RESULT_SUCCESS);
        return params;
    }

    @Override
    public BatchResolveErpDeliverParams transform(String row) {
        return transform(row,null);
    }
    
    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list) {
        throw new UnsupportedOperationException("必须指定物流公司等其他参数");
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list, JSONObject extraParams) {
        String express = extraParams.getString("express");
        LogisticsDto logisticsDto = remoteLogisticsService.findByCode(express);
        if(logisticsDto==null){
            throw new QihoException("必须指定有效的快递公司");
        }
        String logisticCode = logisticsDto.getLogisticsCode();
        String logisticsName = logisticsDto.getLogisticsName();
        for(BatchResolveErpDeliverParams params:list){
            params.setBaiqiLogisticsCode(logisticCode);
            params.setBaiqiLogisticsName(logisticsName);
        }
        DubboResult<Integer> result = remoteErpOrderService.batchResolveErpDeliver(cacheKey,list);
        return result.getResult();
    }
}
