/**
 * Project Name:qiho-manager-biz
 * File Name:CategoryService.java
 * Package Name:com.qiho.manager.biz.service
 * Date:2017年5月16日下午7:40:12
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.manager.biz.service;

import java.util.List;

import com.qiho.manager.biz.vo.CategoryVO;

/**
 * ClassName:CategoryService <br/>
 * 类目管理接口<br/>
 * Date:     2017年5月16日 下午7:40:12 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface CategoryService {

    /**
     * 根据父类目ID查询子类目列表
     *
     * @author zhanglihui
     * @param pid
     * @return 子类目列表
     */
    public List<CategoryVO> getCategoryByPid(long pid);

    /**
     * 根据类目ID删除类目，若删除的是父类目，子类目也会被删除
     *
     * @author zhanglihui
     * @param categoryId
     */
    public void deleteCategoryById(Long categoryId);

    /**
     * 更新类目名称
     *
     * @author zhanglihui
     * @param categoryId
     * @param categoryName
     */
    public void updateCategoryById(Long categoryId, String categoryName);

    /**
     * 批量新增类目
     *
     * @author zhanglihui
     * @param pid
     * @param categoryList
     */
    public void saveCategory(Long pid, List<String> categoryList);

    /**
     * 类目排序，实质上是将一个类目从一个位置移到另一个位置，只需要将这两个位置之间的类目进行排序即可</br>
     * <ul>
     * <dt>排序算法：</dt>
     * <li>将类目向上移时，被移动的payload值更新为移动至位置的类目的payload值，startPayload和endPayload之间的类目的payload值逐个减一</li>
     * <li>将类目向下移时，被移动的payload值更新为移动至位置的类目的payload值，startPayload和endPayload之间的类目的payload值逐个加一</li>
     * </ul>
     *
     * @author zhanglihui
     * @param pid 父类目ID
     * @param startPayload
     * @param endPayload
     */
    public void sortByPayLoad(Long pid, Integer startPayload, Integer endPayload);
}

