package com.qiho.manager.biz.service;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.logistics.LogisticsOrderVO;
import com.qiho.manager.biz.vo.logistics.YTOLogisticsReturnVO;

import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: LogisticsOrderService <br/>
 * Function: 物流子订单Service. <br/>
 * date: 2017年6月3日 下午2:39:13 <br/>
 *
 * @author chencheng
 * @version
 */
public interface LogisticsOrderService {

    /**
     * 分页查询物流子订单
     *
     * @author chencheng
     * @param dto
     * @param pageNum
     * @param pageSize
     * @return
     */
    Pagenation<LogisticsOrderVO> queryList(QueryLogisticsOrderDto dto, Integer pageNum, Integer pageSize);

    /**
     * 物流订单签收，更新订单状态
     *
     * @author chencheng
     * @param logisticsId
     * @param orderStatus
     * @return
     */
    Integer updateLogisticsOrderStatus(String logisticsId, String orderStatus);

    /**
     * 圆通物流状态通知
     *
     * @author chencheng
     * @param logistics_interface
     * @param data_digest
     * @param clientId
     * @param type
     * @return
     */
    YTOLogisticsReturnVO ytoLogisticsMsg(String logisticsInterface, String dataDigest, String clientId,
                                              String type);

    /**
     * 圆通快递走件流程状态查询
     *
     * @author chencheng
     * @param postId
     * @return
     */
    List<LogisticsProcessDto> queryYTOLogisticsProcessByPostId(String postId,String logisticsCode);

    /**
     * 批量物流订单签收
     *
     * @author chencheng
     * @param param
     * @param status 状态
     * @return
     */
    OrderDealWithVO batchSign(BatchAuditOrderParam param, String status);

    /**
     * 手动触发查询ERP系统物流发货信息查询
     *
     * @author chencheng
     * @return
     */
    Boolean manualErpLogisticsSyncQueryTaskJob();

    /**
     * 通过查询走件流程同步物流状态
     * @author zhanglihui
     * @param logisticsOrderStatus 
     */
    void syncLogisticsStatus(String logisticsOrderStatus);

    /**
     * 修改物流订单备注字段
     */
    Boolean updateLogisticsOrderRemark(LogisticsOrderDto param);

    /**
	 * 导出基本数据
     * @return
     */
    Map<String,Object> submitExportDistributeOrder();


    JSONObject queryExpressBlackExportStatus(String taskId);

    /**
     * 查询客服跟单
     */
    Pagenation<LogisticsOrderVO> queryServiceList(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize);
}
