package com.qiho.manager.biz.service;

import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.manager.biz.vo.MerchantSimpleVO;
import com.qiho.manager.biz.vo.OpenInterfaceVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.merchant.MerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;

import java.util.List;

/**
 * 商家服务接口
 *
 * @author chensong
 * @create 2017-11-15 10:24
 **/
public interface MerchantService {

    /**
     * 新建或更新商家信息
     *
     * @param dto
     *
     * @return
     */
    Boolean saveMerchant(MerchantDto dto);

    /**
     * 根据id获取商家信息
     *
     * @param merchantId
     *
     * @return
     */
    MerchantVO findById(Long merchantId);

    /**
     * 根据商家名称模糊匹配
     *
     * @param name
     *
     * @return
     */
    List<MerchantVO> listByName(String name);

    /**
     * 分页查询商家信息
     *
     * @param params
     *
     * @return
     */
    Pagenation<MerchantVO> pageQuery(MerchantQueryParams params);

    /**
     * 查询商家返货方式
     */

    String findByMerchantId(Long merchantId);

    /**
     * 查询所有商家简单信息
     *
     * @return 集合
     */
    List<SpecialSimpleVO> findSimpleAll();

    /**
     * 根据三级ID和商家关联类型查询关联类型ID
     *
     * @param merchantId   商家ID
     * @param relationType 关联类型
     *
     * @return 关联类型ID
     */
    Long findRelationId(Long merchantId, BaiqiMerchantLinkTypeEnum relationType);

    /**
     * 分页查询已存在验证信息的商家信息
     *
     * @param params
     *
     * @return
     */
    Pagenation<OpenInterfaceVO> openInterfacePageQuery(OpenInterfaceQueryParams params);

    /**
     * 保存对外开放商家验证信息
     *
     * @param merchantId
     *
     * @return
     */
    Boolean saveOpenInterface(Long merchantId);

    /**
     * 保存对外开放商家验证信息
     *
     * @param agentId
     *
     * @return
     */
    Boolean saveAgentOpenInterface(Long agentId);

    /**
     * 根据商家名称模糊查询
     *
     * @param merchantName
     *
     * @return
     */
    List<MerchantSimpleVO> findNoOpenInterface(String merchantName);

    /**
     * 验证信息
     * @param appKey
     * @param appSecret
     * @return
     */
    OpenInterfaceDto checkedAppKey(String appKey, String appSecret);

    /**
     * 更新商家版本
     * @param versionSign
     * @param id
     * @return
     */
    Boolean updateMerchantVersion(String versionSign,Long id);
}
