/**
 * Project Name:qiho-manager-biz
 * File Name:OrderService.java
 * Package Name:com.qiho.manager.biz.service
 * Date:2017年6月6日下午2:08:47
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.manager.biz.service;

import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.OrderDetailVO;
import com.qiho.manager.biz.vo.OrderSnapshotVO;
import com.qiho.manager.biz.vo.Pagenation;

import java.util.List;
import java.util.Map;

/**
 * ClassName:OrderService <br/>
 * 订单服务. <br/>
 * Date:     2017年6月6日 下午2:08:47 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface OrderService {

    /**
     * 根据订单ID查询订单详情
     * @author zhanglihui
     * @param orderId
     * @return OrderDetailVO
     */
    OrderDetailVO findByOrderId(String orderId);

    /**
     * 提交导出订单申请
     * @param params
     * @return 导出任务号
     */
    Map<String,Object> submitOrdersExport(OrderPageParams params);

    /**
     * 更新订单商品详情
     * @author zhanglihui
     * @param orderItemParam
     */
    void updateOrderItem(OrderItemParam orderItemParam);

    /**
     * 更新订单买家信息
     * @author zhanglihui
     * @param orderConsumerParam
     */
    void updateOrderConsumer(OrderConsumerParam orderConsumerParam);

    /**
     * 提交批量审核订单任务
     * @param param
     * @return OrderDealWithVO
     */
    OrderDealWithVO batchAuditOrder(BatchAuditOrderParam param);

    Pagenation<OrderSnapshotVO> findApproveOrder(OrderPageParams params);

    /**
     * 结束任务
     * @param taskId
     * @return
     */
    String overTask(String taskId);

    /**
     * 获取用户是否有权限查看订单原始信息
     * @return true-有 false-没有
     */
    boolean orderPrimitiveAuth();

    void batchProcessOrder(Integer type, String fileUrl,String fileName);

    /**
     * 获取订单号的导出状态
     * @param extList
     * @return
     */
    Map<String,Integer> getOrderExportStatusMap(List<String> extList);
}

