package com.qiho.manager.biz.service.advert;

import com.qiho.manager.biz.params.ItemAdvertParam;
import com.qiho.manager.biz.params.advert.DefaultItemAdvertParam;
import com.qiho.manager.biz.params.advert.ItemAdvertSaveParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.DefaultItemAdvertVO;
import com.qiho.manager.biz.vo.advert.ItemAdvertVO;
import com.qiho.manager.common.param.PageParam;

/**
 *              ii.                                         ;9ABH,
 *              SA391,                                    .r9GG35&G
 *              &#ii13Gh;                               i3X31i;:,rB1
 *              iMs,:,i5895,                         .5G91:,:;:s1:8A
 *               33::::,,;5G5,                     ,58Si,,:::,sHX;iH1
 *                Sr.,:;rs13BBX35hh11511h5Shhh5S3GAXS:.,,::,,1AG3i,GG
 *                .G51S511sr;;iiiishS8G89Shsrrsh59S;.,,,,,..5A85Si,h8
 *               :SB9s:,............................,,,.,,,SASh53h,1G.
 *            .r18S;..,,,,,,,,,,,,,,,,,,,,,,,,,,,,,....,,.1H315199,rX,
 *          ;S89s,..,,,,,,,,,,,,,,,,,,,,,,,....,,.......,,,;r1ShS8,;Xi
 *        i55s:.........,,,,,,,,,,,,,,,,.,,,......,.....,,....r9&5.:X1
 *       59;.....,.     .,,,,,,,,,,,...        .............,..:1;.:&s
 *      s8,..;53S5S3s.   .,,,,,,,.,..      i15S5h1:.........,,,..,,:99
 *      93.:39s:rSGB@A;  ..,,,,.....    .SG3hhh9G&BGi..,,,,,,,,,,,,.,83
 *      G5.G8  9#@@@@@X. .,,,,,,.....  iA9,.S&B###@@Mr...,,,,,,,,..,.;Xh
 *      Gs.X8 S@@@@@@@B:..,,,,,,,,,,. rA1 ,A@@@@@@@@@H:........,,,,,,.iX:
 *     ;9. ,8A#@@@@@@#5,.,,,,,,,,,... 9A. 8@@@@@@@@@@M;    ....,,,,,,,,S8
 *     X3    iS8XAHH8s.,,,,,,,,,,...,..58hH@@@@@@@@@Hs       ...,,,,,,,:Gs
 *    r8,        ,,,...,,,,,,,,,,.....  ,h8XABMMHX3r.          .,,,,,,,.rX:
 *   :9, .    .:,..,:;;;::,.,,,,,..          .,,.               ..,,,,,,.59
 *  .Si      ,:.i8HBMMMMMB&5,....                    .            .,,,,,.sMr
 *  SS       :: h@@@@@@@@@@#; .                     ...  .         ..,,,,iM5
 *  91  .    ;:.,1&@@@@@@MXs.                            .          .,,:,:&S
 *  hS ....  .:;,,,i3MMS1;..,..... .  .     ...                     ..,:,.99
 *  ,8; ..... .,:,..,8Ms:;,,,...                                     .,::.83
 *   s&: ....  .sS553B@@HX3s;,.    .,;13h.                            .:::&1
 *    SXr  .  ...;s3G99XA&X88Shss11155hi.                             ,;:h&,
 *     iH8:  . ..   ,;iiii;,::,,,,,.                                 .;irHA
 *      ,8X5;   .     .......                                       ,;iihS8Gi
 *         1831,                                                 .,;irrrrrs&@
 *           ;5A8r.                                            .:;iiiiirrss1H
 *             :X@H3s.......                                .,:;iii;iiiiirsrh
 *              r#h:;,...,,.. .,,:;;;;;:::,...              .:;;;;;;iiiirrss1
 *             ,M8 ..,....,.....,,::::::,,...         .     .,;;;iiiiiirss11h
 *             8B;.,,,,,,,.,.....          .           ..   .:;;;;iirrsss111h
 *            i@5,:::,,,,,,,,.... .                   . .:::;;;;;irrrss111111
 *            9Bi,:,,,,......                        ..r91;;;;;iirrsss1ss1111
 *
 * 商品广告位管理服务接口
 *
 * @author chensong
 * @create 2018-08-17
 */
public interface ItemAdvertService {

    /**
     * 分页查询商品广告位
     * @param param
     * @return
     */
    Pagenation<ItemAdvertVO> queryPage(PageParam param);

    /**
     * 商品广告位保存
     * @param param
     * @return
     */
    Boolean saveItemAdvert(ItemAdvertSaveParam param);

    /**
     * 删除商品广告位
     * @param id 商品广告位的id
     * @return
     */
    Boolean deleteItemAdvert(Long id);

    /**
     * 修改商品广告位的开启状态
     * @param id            商品广告位的id
     * @param advertStatus  商品广告位的状态 true-开启 false-关闭
     * @return
     */
    Boolean alterAdvertStatus(Long id, Boolean advertStatus);

    /**
     * 修改保存默认商品广告位资源配置
     * @param param
     * @return
     */
    Boolean saveDefaultConfig(DefaultItemAdvertParam param);


    /**
     * 获取继续逛逛url
     * @return
     */
    String findAroundUrl();

    /**
     * 保存接续逛逛url
     * @param url
     * @return
     */
    Boolean saveAroundUrl(String url);

    /**
     * 获取默认的广告位资源
     * @return
     */
    DefaultItemAdvertVO findDefualtItemAdvert();
}
