package com.qiho.manager.biz.service.advert.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.constant.ConfigConstant;
import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.BaiqiItemAdvertDto;
import com.qiho.center.api.dto.advert.DefaultItemAdvertDto;
import com.qiho.center.api.enums.EnableStatusEnum;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.api.params.advert.ItemAdvertQueryParams;
import com.qiho.center.api.remoteservice.RemoteConfigService;
import com.qiho.center.api.remoteservice.advert.RemoteItemAdvertService;
import com.qiho.manager.biz.params.advert.DefaultItemAdvertParam;
import com.qiho.manager.biz.params.advert.ItemAdvertSaveParam;
import com.qiho.manager.biz.service.advert.ItemAdvertService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.DefaultItemAdvertVO;
import com.qiho.manager.biz.vo.advert.ItemAdvertVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.param.PageParam;
import com.qiho.manager.common.util.AssertUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author chensong
 * @create 2018-08-17
 */
@Service
public class ItemAdvertServiceImpl implements ItemAdvertService {

    @Autowired
    private RemoteItemAdvertService remoteItemAdvertService;

    @Autowired
    private RemoteConfigService remoteConfigService;



    @Override
    public Pagenation<ItemAdvertVO> queryPage(PageParam param) {

        ItemAdvertQueryParams queryParams = new ItemAdvertQueryParams();
        queryParams.setOffset((param.getPageNum() - 1) * param.getPageSize());
        queryParams.setMax(param.getPageSize());
        PagenationDto<BaiqiItemAdvertDto> pageDto = remoteItemAdvertService.queryPage(queryParams);

        Pagenation<ItemAdvertVO> page = new Pagenation<>();
        page.setTotal(pageDto.getTotal());
        if (pageDto.getTotal() == 0) {
            return page.emptyPage();
        }
        page.setList(convertVOList(pageDto.getList()));

        return page;
    }


    @Override
    public Boolean saveItemAdvert(ItemAdvertSaveParam param) {

        if (param.getId() == null) {
            // 新建商品广告位
            return createItemAdvert(param);

        }else {
            // 更新商品广告位
            return updateItemAdvert(param);
        }
    }


    @Override
    public Boolean deleteItemAdvert(Long id) {

        ResultDto<Boolean> resultDto = remoteItemAdvertService.deleteById(id);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (!resultDto.getResult()){
            throw new QihoManagerException("删除商品广告位失败");
        }

        return true;
    }


    @Override
    public Boolean alterAdvertStatus(Long id, Boolean advertStatus) {

        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setId(id);
        dto.setAdvertStatus(advertStatus);
        dto.setOpeartor(RequestTool.getAdmin().getName());

        ResultDto<Boolean> resultDto = remoteItemAdvertService.alterAdvertStatus(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (!resultDto.getResult()) {
            throw new QihoManagerException("修改商品广告位状态失败");
        }

        return true;
    }


    @Override
    public Boolean saveDefaultConfig(DefaultItemAdvertParam param) {
        DefaultItemAdvertDto dto = BeanUtils.copy(param, DefaultItemAdvertDto.class);
        ConfigParams configParams = new ConfigParams();
        configParams.setConfigName(ConfigConstant.DEFAULT_ITEM_ADVERT);
        configParams.setConfigValue(JSONObject.toJSONString(dto));

        ResultDto<Boolean> resultDto = remoteConfigService.insertOrUpdateConfig(configParams);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }

        return true;
    }


    @Override
    public String findAroundUrl() {
        ConfigDto configDto = remoteConfigService.fetchConfigByName(ConfigConstant.KEEP_AROUND_URL);
        if (configDto == null) {
            return null;
        }
        return configDto.getConfigValue();
    }


    @Override
    public Boolean saveAroundUrl(String url) {
        AssertUtil.stringNotBlank(url, "继续逛逛Url不能为空");

        url = StringEscapeUtils.unescapeHtml4(url);
        ConfigParams configParams = new ConfigParams();
        configParams.setConfigName(ConfigConstant.KEEP_AROUND_URL);
        configParams.setConfigValue(url.trim());

        ResultDto<Boolean> resultDto = remoteConfigService.insertOrUpdateConfig(configParams);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }

        return true;
    }

    @Override
    public DefaultItemAdvertVO findDefualtItemAdvert() {
        ConfigDto configDto = remoteConfigService.fetchConfigByName(ConfigConstant.DEFAULT_ITEM_ADVERT);
        if (configDto == null) {
            return null;
        }

        DefaultItemAdvertDto dto = JSON.parseObject(configDto.getConfigValue(), DefaultItemAdvertDto.class);
        return BeanUtils.copy(dto, DefaultItemAdvertVO.class);
    }


    /**
     * 新建商品广告位
     * @param param
     * @return
     */
    private Boolean createItemAdvert(ItemAdvertSaveParam param){

        AssertUtil.numericIsPositive(param.getItemId(), "商品id不合法");

        if (param.getAdvertId() != null && param.getAdvertId() < 1L) {
            throw new QihoManagerException("广告位id不合法");
        }

        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setItemId(param.getItemId());
        dto.setAdvertId(param.getAdvertId());
        dto.setAdvertStatus(EnableStatusEnum.OFF.isStatus());
        dto.setOpeartor(RequestTool.getAdmin().getName());

        ResultDto<Long> resultDto = remoteItemAdvertService.insertItemAdvert(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }

        return true;
    }


    /**
     * 更新商品广告位
     * @param param
     * @return
     */
    private Boolean updateItemAdvert(ItemAdvertSaveParam param){

        if (param.getAdvertId() != null && param.getAdvertId() < 1L) {
            throw new QihoManagerException("广告位id不合法");
        }

        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setId(param.getId());
        dto.setItemId(param.getItemId());
        dto.setAdvertId(param.getAdvertId());
        dto.setOpeartor(RequestTool.getAdmin().getName());

        ResultDto<Boolean> resultDto = remoteItemAdvertService.updateItemAdvert(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }

        if (!resultDto.getResult()){
            throw new QihoManagerException("更新商品广告位失败");
        }

        return true;
    }


    /**
     * 类型转换
     * @param dtoList
     * @return
     */
    private List<ItemAdvertVO> convertVOList(List<BaiqiItemAdvertDto> dtoList){
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayList();
        }

        List<ItemAdvertVO> list = new ArrayList<>();
        dtoList.forEach(e -> {
            ItemAdvertVO vo = BeanUtils.copy(e, ItemAdvertVO.class);
            // itemId为零的是默认数据 在这里做转换
            vo.setItemId(e.getItemId() == 0L ? "默认" : String.valueOf(e.getItemId()));
            list.add(vo);
        });

        return list;
    }












}
