package com.qiho.manager.biz.service.agent;

import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.manager.biz.params.agent.AgentSaveParam;
import com.qiho.manager.biz.vo.AgentSimpleVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.agent.AgentVO;
import com.qiho.manager.biz.vo.merchant.SimpleMerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;

import java.util.List;

/**
 * 代理商service
 * Author: zhanghuifeng
 * Date:   14:02 2017/12/15
 */
public interface BaiqiAgentService {

	/**
	 * 分页查询代理商
	 * @param params 数据
	 * @return 分页结果
	 */
	Pagenation<AgentVO> pageQuery(AgentPageParam params);

	/**
	 * 保存代理商
	 * @param agentSaveParam 参数
	 * @return boolean
	 */
	Boolean save(AgentSaveParam agentSaveParam);

	/**
	 * 获取所有未被代理商关联的商家
	 * @return 集合
	 */
	List<SimpleMerchantVO> findMerchant();

	/**
	 * 根据代理商id获取商家
	 * @param agentId 代理商id
	 * @return 集合
	 */
	List<SimpleMerchantVO> findMerchantByAgentId(Long agentId);

	/**
	 * 所有代理商简单信息
	 * @return集合
	 */
	List<SpecialSimpleVO> findAll();

	/**
	 * 根据代理商名称模糊查询
	 *
	 * @param agentName
	 *
	 * @return
	 */
	List<AgentSimpleVO> findNoOpenInterface(String agentName);
}
