package com.qiho.manager.biz.service.component;

import com.qiho.manager.biz.params.component.ComponentParam;
import com.qiho.manager.biz.vo.component.ComponentVO;

import java.util.List;

/** 组件服务相关接口
 * @author chensong
 * @create 2018-07-25
 */
public interface ComponentService  {

    /**
     * 新增组件
     * @param param
     * @return
     */
    Boolean createComponent(ComponentParam param);

    /**
     * 修改组件
     * @param param
     * @return
     */
    Boolean updateComponent(ComponentParam param);

    /**
     * 根据id查找组件
     * @param id
     * @return
     */
    ComponentVO findById(Long id);

    /**
     * 根据组件类型查询
     * @param typeNum
     * @return
     */
    List<ComponentVO> findByType(Integer typeNum);


}
