package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.api.remoteservice.abtest.RemoteTestMetadataService;
import com.qiho.manager.biz.service.AbTestDetailService;
import com.qiho.manager.biz.vo.AbTestDetailVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.common.exception.QihoManagerException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by qianjue on 2017/10/12.
 */
@Service
public class AbTestDetailServiceImpl implements AbTestDetailService {

	@Resource
	RemoteTestMetadataService  remoteTestMetadataService;

	@Resource
	RemoteItemService remoteItemService;

	@Override
	public Pagenation<AbTestDetailVO> queryListByPage(TestMetadataQueryParam param) {
		DubboResult<ItemSimpleDto> itemResult =  remoteItemService.queryItemSimpleDto(param.getItemId());
		if(!itemResult.isSuccess() || null==itemResult.getResult()){
			throw new QihoManagerException("没有找到该商品");
		}
		Pagenation<AbTestDetailVO> pagenation = new Pagenation<>();
		PagenationDto<TestMetadataDto> pagenationDto = null;
		try{
			pagenationDto = remoteTestMetadataService.queryListByPage(param);
		}catch (BizException e){
			throw new QihoManagerException(e.getMessage());
		}
		pagenation.setTotal(pagenationDto.getTotal());
		List<AbTestDetailVO> pageList = Lists.newArrayList();
		pagenationDto.getList().stream().forEach(dto ->{
			AbTestDetailVO vo = new AbTestDetailVO();
			vo.setId(dto.getId());
			vo.setItemId(dto.getItemId());
			vo.setItemName(dto.getItemName());
			vo.setName(dto.getDataName());
			vo.setDescription(dto.getDataDesc());
			vo.setDetail(dto.getMetadataValue());
			vo.setPicUrl(dto.getPicUrl());
			pageList.add(vo);
		});
		pagenation.setList(pageList);
		return pagenation;
	}

	@Override
	public void saveTestDetail(TestMetadataDto metadataDto) {
		metadataDto.setMetadataKey(MetadataTypeEnum.DETAIL.getCode());
		try{
			if(null == metadataDto.getId() || 0 == metadataDto.getId().intValue()){
				metadataDto.setSkinType(0);
				remoteTestMetadataService.saveTestMetadata(metadataDto);
			}else{
				remoteTestMetadataService.updateTestMetadata(metadataDto);
			}
		}catch(BizException e){
			throw new QihoManagerException(e.getMessage());
		}
	}

	@Override
	public void deleteTestDetail(Long id) {
		try {
			remoteTestMetadataService.deleteTestMetadata(id);
		}catch(BizException e){
			throw new QihoManagerException(e.getMessage());
		}
	}

	@Override
	public void syncToItemDetail(Long id,Long updatorId) {
		try{
			remoteTestMetadataService.syncToItemInfo(id,updatorId);
		}catch (BizException e){
			throw new QihoManagerException(e.getMessage());
		}
	}

	@Override
	public AbTestDetailVO queryTestDetailById(Long id) {
		TestMetadataDto testMetadataDto = remoteTestMetadataService.selectById(id);
		AbTestDetailVO vo = new AbTestDetailVO();
		vo.setItemId(testMetadataDto.getItemId());
		vo.setItemName(testMetadataDto.getItemName());
		vo.setPicUrl(testMetadataDto.getPicUrl());
		vo.setId(testMetadataDto.getId());
		vo.setName(testMetadataDto.getDataName());
		vo.setDescription(testMetadataDto.getDataDesc());
		vo.setDetail(testMetadataDto.getMetadataValue());
		return vo;
	}
}
