package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.api.remoteservice.RemoteAbTestSkuService;
import com.qiho.center.api.remoteservice.item.RemoteItemSkuService;
import com.qiho.manager.biz.service.AbTestSkuService;
import com.qiho.manager.biz.vo.AbTestSkuVO;
import com.qiho.manager.biz.vo.ItemSkuVO;
import com.qiho.manager.biz.vo.Pagenation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.List;

/**
 * Created by weny.cai on 2017/10/12.
 */
@Service
public class AbTestSkuServiceImpl implements AbTestSkuService {

    @Autowired
    RemoteItemSkuService remoteItemSkuService;

    @Autowired
    RemoteAbTestSkuService remoteAbTestSkuService;

    @Override
    public List<ItemSkuVO> getSkuByItemId(Long itemId) {
        List<ItemSkuDto> list = remoteItemSkuService.getSkuByItemId(itemId);
        return BeanUtils.copyList(list,ItemSkuVO.class);
    }

    @Override
    public void save(AbTestSkuDto abTestSkuDto, List<ItemSkuDto> skus) throws BizException{
        remoteAbTestSkuService.save(skus,abTestSkuDto);
    }

    @Override
    public void delete(Long id) throws BizException {
        remoteAbTestSkuService.delete(id);
    }

    @Override
    public Pagenation<AbTestSkuVO> queryList(TestMetadataQueryParam testMetadataQueryParam) throws BizException {
        PagenationDto<AbTestSkuDto> pagenation = remoteAbTestSkuService.queryList(testMetadataQueryParam);
        Pagenation<AbTestSkuVO> resultPage = new Pagenation<>();
        resultPage.setTotal(pagenation.getTotal());
        List<AbTestSkuVO> resultList = BeanUtils.copyList(pagenation.getList(),AbTestSkuVO.class);
        for (AbTestSkuVO abTestSkuVO : resultList) { // 计算价格区间
            List<ItemSkuDto> skus = abTestSkuVO.getSkus();
            if(CollectionUtils.isEmpty(skus))
                continue;
            Integer minPrice = Integer.MAX_VALUE;
            Integer maxPrice = 0;
            for (ItemSkuDto dto : skus) {
                if(dto.getSellingPrice()>maxPrice){
                    maxPrice = dto.getSellingPrice();
                }
                if(dto.getSellingPrice()<minPrice){
                    minPrice = dto.getSellingPrice();
                }
            }
            DecimalFormat df = new DecimalFormat("0.00");//格式化小数
            if(maxPrice.equals(minPrice)){
                abTestSkuVO.setPriceRange(df.format((float)maxPrice/100));
            }else {
                abTestSkuVO.setPriceRange(df.format((float)minPrice/100)+"~"+df.format((float)maxPrice/100));
            }
        }
        resultPage.setList(resultList);
        return resultPage;
    }

    @Override
    public AbTestSkuVO queryDetail(Long id) throws BizException {
        AbTestSkuDto dto = remoteAbTestSkuService.queryDetail(id);
        return BeanUtils.copy(dto,AbTestSkuVO.class);
    }

    @Override
    public void syncToItemSku(Long id,Long userId) throws BizException {
        remoteAbTestSkuService.syncToItemSku(id,userId);
    }

}
