package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.ordertaskhandler.ExpressBlackListExportRunnable;
import com.qiho.manager.biz.service.ExpressBlackService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * Created by qianjue on 2017/7/19.
 * 物流不配送区域service实现类
 * Controller层建议不要调用dubbo接口,包装一层
 */
@Service
public class ExpressBlackListServiceImpl implements ExpressBlackService,ApplicationContextAware {

	@Autowired
	private RemoteExpressBlackListService   remoteExpressBlackListService;

	@Autowired
	private ApplicationContext applicationContext;

	@Resource
	private ExecutorService executorService;
	
	@Resource(name = "stringRedisTemplate")
	private StringRedisTemplate     redisTemplate;

	@Override
	public int queryExpressBlackListNum(ExpressBlackListPageParams params) {
		DubboResult<Integer> result = remoteExpressBlackListService.finaExpressBlackNum(params);
		if(result.isSuccess()){
			return result.getResult();
		}
		return 0;
	}

	@Override
	public Map<String, Object> submitExpressBlackPageExport(ExpressBlackListPageParams params) {
		ExpressBlackListExportRunnable runnable =applicationContext.getBean(ExpressBlackListExportRunnable.class);
		runnable.setParams(params);
		Map<String,Object> info = runnable.init();
		executorService.submit(runnable);
		return info;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext){
		this.applicationContext = applicationContext;
	}

	@Override
	public JSONObject queryExpressBlackExportStatus(String taskId) {
		CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST;
		String cacheKey = constantseEnum.getCacheKey(taskId);
        BoundHashOperations<String,String,Object> operations = redisTemplate.boundHashOps(cacheKey);
        Map<String,Object> info = operations.entries();
        JSONObject json = new JSONObject();
        if(info.isEmpty()){
            json.put("success",true);
        }else{
            json.putAll(info);
            if(json.getBoolean("success")){
            	redisTemplate.delete(cacheKey);
            }
        }
        json.put("success",json.getBoolean("success"));
        return json;
	}
}
