package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.MainItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.remoteservice.RemoteMainItemService;
import com.qiho.manager.biz.service.MainItemService;
import com.qiho.manager.biz.vo.MainItemVO;
import com.qiho.manager.biz.vo.Pagenation;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2017/8/30.
 */
@Service
public class MainItemServiceImpl implements MainItemService{

    @Resource
    private RemoteMainItemService remoteMainItemService;

    @Override
    public DubboResult<Integer> addMainItem(MainItemDto mainItemDto) {
       return remoteMainItemService.addMainItem(mainItemDto);
    }

    @Override
    public DubboResult<Integer> deleteMainItems(List<Long> ids) {
        return remoteMainItemService.deleteMainItems(ids);
    }

    @Override
    public DubboResult<Integer> editMainItem(MainItemDto mainItemDto) {
        return remoteMainItemService.editMainItem(mainItemDto);
    }

    @Override
    public MainItemVO queryMainItem(Long id) {
        DubboResult<MainItemDto> dubboResult = remoteMainItemService.queryMainItem(id);
        return BeanUtils.copy(dubboResult.getResult(),MainItemVO.class);
    }

    @Override
    public Pagenation<MainItemVO> queryMainItems() {
        DubboResult<PagenationDto<MainItemDto>> dubboResult = remoteMainItemService.queryMainItems();
        List<MainItemVO> vos = Lists.newArrayList();
        List<MainItemDto> dtos =  dubboResult.getResult().getList();
        if(dtos!=null){
            for (MainItemDto dto : dtos) {
                MainItemVO mainItemVO = BeanUtils.copy(dto,MainItemVO.class);
                vos.add(mainItemVO);
            }
        }
        Pagenation<MainItemVO> pagenation = new Pagenation<>();
        pagenation.setList(vos);
        return pagenation;
    }

    @Override
    public Boolean sortMainItem(Long mainIitemId, Integer originPayload, Integer newPayload) {
        return remoteMainItemService.sortMainItem(mainIitemId,originPayload,newPayload).getResult();
    }

}
