package com.qiho.manager.biz.service.impl.blacklist;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;
import com.qiho.center.api.dto.bklist.StrategyDto;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListStrategrService;
import com.qiho.manager.biz.service.blacklist.BlackListStrategyService;
import com.qiho.manager.biz.vo.blackList.BlackListStrategyVO;
import com.qiho.manager.biz.vo.merchant.SimpleMerchantVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-04-25 17:25
 **/
@Service
public class BlackListStrategyServiceImpl implements BlackListStrategyService {

    @Autowired
    private RemoteBlackListStrategrService remoteBlackListStrategrService;


    @Override
    public BlackListStrategyVO findById(Long id) {
        if (null == id || id.intValue() <= 0L) {
            return null;
        }
        BlackListStrategyDto blackListStrategyDto = remoteBlackListStrategrService.findById(id);
        if (null == blackListStrategyDto) {
            return null;
        }
        return convertBlackListStrategyToVO(blackListStrategyDto);
    }

    @Override
    public List<BlackListStrategyVO> queryBlackListStrategy(Long merchantId) {
        // 默认查询所有的策略
        if (null == merchantId || merchantId.longValue() < 0L) {
            merchantId = -1L;
        }

        // 查询策略
        List<BlackListStrategyDto> blackListStrategyDtoList = remoteBlackListStrategrService.listByMerchantId(merchantId);
        if (CollectionUtils.isEmpty(blackListStrategyDtoList)) {
            return Lists.newArrayList();
        }

        return blackListStrategyDtoList.stream().map(this::convertBlackListStrategyToVO).collect(Collectors.toList());
    }

    @Override
    public Boolean deleteBlackListStrategy(Long id) {
        if (null == id || id.intValue() <= 0L) {
            throw new QihoManagerException("策略id不合法");
        }
        ResultDto<Boolean> resultDto = remoteBlackListStrategrService
                .deleteBlackListStrategy(id, RequestTool.getAdmin().getName());
        if (!resultDto.isSuccess()){
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveBlackListStrategy(BlackListStrategyDto param) {
        if (param.getUseType() == BlackListUseTypeEnum.PART){
            // 部分商家要校验商家id列表
            if (CollectionUtils.isEmpty(param.getMerchantIdList())){
                throw new QihoManagerException("商家id列表不能为空");
            }
        }

        ResultDto<Boolean> resultDto;
        if (param.getId() == null) {
            // 新增
            resultDto = remoteBlackListStrategrService.createBlackListStrategy(param);
        } else {
            // 修改
            resultDto = remoteBlackListStrategrService.updateBlackListStrategy(param);
        }

        if (!resultDto.isSuccess()){
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }

    /**
     * 将黑名单策略Dto转成Vo
     * @param dto
     * @return
     */
    private BlackListStrategyVO convertBlackListStrategyToVO(BlackListStrategyDto dto){
        BlackListStrategyVO vo = BeanUtils.copy(dto, BlackListStrategyVO.class);
        vo.setUseType(dto.getUseType().getNum());
        vo.setDealType(dto.getDealType().getNum());
        StrategyDto strategyDto = dto.getStrategy();
        vo.setStartDay(strategyDto.getStartDay());
        vo.setEndDay(strategyDto.getEndDay());
        vo.setSuccessRate(strategyDto.getSuccessRate());
        vo.setOrderCount(strategyDto.getOrderCount());
        if (CollectionUtils.isNotEmpty(dto.getMerchantList())) {
            vo.setMerchantList(BeanUtils.copyList(dto.getMerchantList(), SimpleMerchantVO.class));
        }
        return vo;
    }





}
