package com.qiho.manager.biz.service.impl.ordertmp;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.api.remoteservice.ordertmp.RemoteOrderTmpService;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.manager.biz.runnable.OrderTmpExportRunnable;
import com.qiho.manager.biz.service.ordertmp.OrderTmpService;
import com.qiho.manager.biz.vo.*;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpDetailVO;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * @author chensong
 * @create 2018-05-17 15:30
 **/
@Service
public class OrderTmpServiceImpl implements OrderTmpService, ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpServiceImpl.class);

    @Autowired
    private RemoteOrderTmpService remoteOrderTmpService;

    @Autowired
    private ApplicationContext applicationContext;

    @Resource
    private ExecutorService executorService;

    @Resource
    private RemotePageBackendService remotePageBackendService;

    @Autowired
    private RemoteSkinService remoteSkinService;

    @Override
    public Pagenation<OrderTmpVO> queryOrderTmpPage(OrderTmpPageParam param) {
        Pagenation<OrderTmpVO> page = new Pagenation<>();

        PagenationDto<OrderTmpDetailDto> pagenation = remoteOrderTmpService.queryOrderTmpPage(param);
        int count = pagenation.getTotal();
        page.setTotal(count);

        if (count == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }

        List<OrderTmpVO> orderTmpVOList = Lists.transform(pagenation.getList(), e ->{
            OrderTmpVO orderTmpVO = BeanUtils.copy(e, OrderTmpVO.class);
            orderTmpVO.setOrderStatus(e.getOrderStatusEnum().getDesc());
            orderTmpVO.setGmtCreate(DateUtils.getSecondStr(e.getGmtCreate()));
            return orderTmpVO;
        });
        page.setList(orderTmpVOList);

        return page;
    }

    @Override
    public boolean toValid(String orderId) {
        ResultDto<Boolean> resultDto = remoteOrderTmpService.toValid(orderId);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }


        return true;
    }

    @Override
    public Map<String, Object> submitOrderExport(OrderTmpPageParam param) {
        OrderTmpExportRunnable runnable = applicationContext.getBean(OrderTmpExportRunnable.class);
        runnable.setPageParam(param);
        Map<String,Object> info = runnable.init();
        executorService.submit(runnable);

        int count = remoteOrderTmpService.countPageQuery(param);
        if(count <= 0 ){
            throw new QihoManagerException("没有需要导出的记录");
        }
        info.put("count", count);
        return info;
    }

    @Override
    public OrderTmpDetailVO getDetail(String orderId) {
        OrderTmpDetailDto orderTmpDetailDto = remoteOrderTmpService.findByOrderId(orderId);
        if (null == orderTmpDetailDto) {
            throw new QihoManagerException("临时订单不存在");
        }

        OrderTmpDetailVO orderTmpDetailVO = new OrderTmpDetailVO();

        // 订单基本信息
        OrderVO order = BeanUtils.copy(orderTmpDetailDto, OrderVO.class);
        order.setOrderStatus(OrderTmpStatusEnum.getByNum(orderTmpDetailDto.getOrderStatus()).getDesc());
        order.setGmtCreate(DateUtils.getSecondStr(orderTmpDetailDto.getGmtCreate()));
        order.setGmtModified(DateUtils.getSecondStr(orderTmpDetailDto.getGmtModified()));
        order.setDelivery(orderTmpDetailDto.getDeliveryEnum().getDesc());
        orderTmpDetailVO.setOrder(order);

        // 订单商品
        OrderItemVO orderItemVO = BeanUtils.copy(orderTmpDetailDto, OrderItemVO.class);
        orderItemVO.setCostPrice(orderTmpDetailDto.getItemCost());
        orderTmpDetailVO.setOrderItem(orderItemVO);

        // 渠道信息
        ChannelInfoVO channelInfoVO = BeanUtils.copy(orderTmpDetailDto, ChannelInfoVO.class);
        orderTmpDetailVO.setChannelInfo(channelInfoVO);

        // 皮肤
        OrderSkinVO skinVO = getSkinVO(orderTmpDetailDto.getUrl(), orderTmpDetailDto.getSkinId());
        orderTmpDetailVO.setSkinItem(skinVO);

        // 防作弊
        List<String> anticheatRules = orderTmpDetailDto.getAnticheatRules();
        orderTmpDetailVO.setAnticheateList(anticheatRules);

        // 处理订单扩展字段
        String jsonExt = orderTmpDetailDto.getExtJson();
        if (StringUtils.isNotBlank(jsonExt)) {
            try {
                orderTmpDetailVO.getOrder().setExt(JSONObject.parseObject(jsonExt, OrderDetailExtVo.class));
            } catch (Exception e) {
                LOGGER.info("解析订单扩展信息错误 extjson={}", jsonExt, e);
            }
        }

        return orderTmpDetailVO;
    }

    private OrderSkinVO getSkinVO(String url, Long skinId) {

        OrderSkinVO skinItem = new OrderSkinVO();

        skinItem.setSkinId(skinId);

        //新页面
        if(url.contains("detail2")){

            BaiqiPageDto pageDto = remotePageBackendService.findById(skinId);
            if(pageDto != null){
                skinItem.setSkinName(pageDto.getPageName());
            }
        }else {
            // 老皮肤
            try {
                DubboResult<SkinDto> result = remoteSkinService.querySkinById(skinId);
                if (result.isSuccess() && result.getResult() != null) {
                    skinItem.setSkinName(result.getResult().getSkinName());
                }
            } catch (QihoManagerException e) {
                LOGGER.error("order detail get skin info error, skinId:{} ", skinId);
            }
        }

        return skinItem;
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
