package com.qiho.manager.biz.service.impl.tag;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagService;
import com.qiho.manager.biz.service.tag.TagService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.tag.TagVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author chensong
 * @create 2018-03-22 14:15
 **/
@Service
public class TagServiceImpl implements TagService {

    @Autowired
    private RemoteTagService remoteTagService;


    @Override
    public Boolean save(TagDto tagDto) {
        AdminDto adminDto = RequestTool.getAdmin();
        tagDto.setModifier(adminDto.getName());
        if (tagDto!=null) {
            tagDto.setCreator(adminDto.getName());
        }

        ResultDto<Boolean> result = remoteTagService.saveTag(tagDto);
        if (!result.isSuccess()){
            throw new QihoManagerException(result.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean delete(Long id) {
        return remoteTagService.delete(id);
    }

    @Override
    public Pagenation<TagVO> queryPage(TagPageParam param) {
        Pagenation<TagVO> page = new Pagenation<>();
        PagenationDto<TagDto> pagenationDto = remoteTagService.queryPage(param);
        page.setTotal(pagenationDto.getTotal());
        if (pagenationDto.getTotal().intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(BeanUtils.copyList(pagenationDto.getList(), TagVO.class));
        return page;
    }

    @Override
    public List<TagVO> findByTypeId(Long typeId) {
        List<TagDto> tagDtoList = remoteTagService.findByTypeId(typeId);
        return BeanUtils.copyList(tagDtoList, TagVO.class);
    }

    @Override
    public List<TagVO> findItemTags(Long itemId) {
        List<TagDto> tagDtoList = remoteTagService.findByItemId(itemId);
        return BeanUtils.copyList(tagDtoList, TagVO.class);
    }

    @Override
    public Boolean saveItemTag(Long itemId, List<Long> tagIds) {
        ResultDto<Boolean> resultDto = remoteTagService.saveItemTag(itemId, tagIds);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return Boolean.TRUE;
    }


}
