package com.qiho.manager.biz.service.logistics;

import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.logistics.LogisticsNicknameVO;
import com.qiho.manager.biz.vo.logistics.LogisticsVO;

import java.util.List;
import java.util.Map;

/**
 * 物流公司service
 * Author: zhanghuifeng
 * Date:   10:30 2017/12/28
 */
public interface LogisticsService {

    /**
     * 获取所有百奇物流公司列表
     * @return 集合
     */
    List<LogisticsDto> findAll();

    /**
     * 分页查询物流公司信息
     * @param param
     * @return
     */
    Pagenation<LogisticsVO> querypage(LogisticsQueryParam param);

    /**
     * 获取物流公司的外部名称
     * @param logisticsId 物流公司id
     * @return
     */
    List<LogisticsNicknameVO> findNickname(Long logisticsId);

    /**
     * 新增物流公司别称
     * @param logisticsId
     * @param nickname
     * @return
     */
    Boolean addNickname(Long logisticsId, String nickname);

    /**
     * 删除物流公司别称
     * @param id
     * @return
     */
    Boolean deleteNickname(Long id);

    /**
     * 新增物流公司
     * @param logisticsCode
     * @param logisticsName
     * @return
     */
    String insertLogistics(String logisticsCode, String logisticsName);

    /**
     * 删除物流公司
     * @param id
     * @return
     */
    String deleteLogistics(Long id);

    /**
     * 获取百奇物流公司code和name映射
     * @return map
     */
    Map<String, String> getBaiqiLogisticsCodeToName();
}
