package com.qiho.manager.biz.service.merchant;

import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.merchant.MerchantUndeliveryVO;
import com.qiho.manager.biz.vo.merchant.UndeliveryExportVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 商家不配送service
 *
 * @author peanut.huang
 * @date 2018/1/10.
 */
public interface MerchantUndeliveryService {

    /**
     * 分页查询
     *
     * @param merchantId   商家id
     * @param regionCode   行政区域代码
     * @param pageNum
     * @param pageSize
     * @return
     */
    Pagenation<MerchantUndeliveryVO> find4Page(Long merchantId, String regionCode, Integer pageNum, Integer pageSize);

    /**
     * 删除
     *
     * @param idList
     * @return
     */
    boolean deleteUndelivery(List<Long> idList);

    /**
     * import
     *
     * @param encodeType 编码类型 mac用户：gbk, windows用户：utf-8
     * @param file  文件
     */
    void importUndelivery(String encodeType, MultipartFile file);

    /**
     * export
     *
     * @param merchantId
     * @param regionCode
     * @param fileName
     */
    UndeliveryExportVO exportUndelivery(Long merchantId, String regionCode, String encodeType, String fileName);
}
