package com.qiho.manager.biz.service.order.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.user.UserEvaluateDto;
import com.qiho.center.api.params.user.UserEvaluatePagingParams;
import com.qiho.center.api.remoteservice.user.RemoteUserEvaluateService;
import com.qiho.manager.biz.service.order.UserEvaluateService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.order.UserEvaluatePagingVO;
import com.qiho.manager.common.util.StringUtil;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;

/**
 *  用户评价
 *
 * @author peanut.huang
 * @date 2018/6/6.
 */
@Service
public class UserEvaluateServiceImpl implements UserEvaluateService {

    @Resource
    private RemoteUserEvaluateService remoteUserEvaluateService;


    @Override
    public Pagenation<UserEvaluatePagingVO> findPaging(UserEvaluatePagingParams pagingParam) {

        Pagenation<UserEvaluatePagingVO> pagenation = new Pagenation<>();

        // 查询分页
        PagenationDto<UserEvaluateDto> pagenationDto = remoteUserEvaluateService.findPaing(pagingParam);

        List<UserEvaluateDto> evaluateDtoList = pagenationDto.getList();
        int total = pagenationDto.getTotal();

        if(CollectionUtils.isEmpty(evaluateDtoList) || total <= 0){
            return pagenation;
        }

        pagenation.setTotal(total);
        pagenation.setList(transVO(evaluateDtoList, "PAGING"));

        return pagenation;
    }

    private List<UserEvaluatePagingVO> transVO(List<UserEvaluateDto> evaluateDtoList, String optType) {
        List<UserEvaluatePagingVO> result = Lists.newArrayListWithExpectedSize(evaluateDtoList.size());

        evaluateDtoList.forEach(dto ->{
            UserEvaluatePagingVO pagingVO = BeanUtils.copy(dto, UserEvaluatePagingVO.class);

            // set date
            pagingVO.setGmtCreate(DateUtils.getSecondStr(dto.getGmtCreate()));

            // 导出操作，过滤评价内容中的emoji字符
            if(exportOpt.equals(optType)){
                pagingVO.setEvaluateContent(StringUtil.removeFourChar(dto.getEvaluateContent()));
            }

            result.add(pagingVO);
        });

        return result;
    }

    private String exportOpt = "EXPORT";

    @Override
    public List<UserEvaluatePagingVO> findExportList(UserEvaluatePagingParams pagingParam) {
        List<UserEvaluateDto>  evaluateDtoList = remoteUserEvaluateService.findEvaluateList(pagingParam);
        return transVO(evaluateDtoList, exportOpt);
    }
}
