package com.qiho.manager.biz.service.orderexport.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.center.api.remoteservice.orderexport.RemoteOrderExportTemplateBackendService;
import com.qiho.manager.biz.service.orderexport.OrderExportTemplateService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.orderexport.FieldVO;
import com.qiho.manager.biz.vo.orderexport.OrderExportTemplateVO;
import com.qiho.manager.biz.vo.orderexport.TemplateFieldVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * 订单模板service
 *
 * @author peanut.huang
 * @date 2017/11/24.
 */
@Service("orderExportTemplateService")
public class OrderExportTemplateServiceImpl implements OrderExportTemplateService {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderExportTemplateServiceImpl.class);

    @Resource
    private RemoteOrderExportTemplateBackendService remoteOrderExportTemplateBackendService;

    @Override
    public Pagenation<OrderExportTemplateVO> find4Page(OrderExportTemplateQueryParams param) {

        //查询
        PagenationDto<OrderExportTemplateDto> remoteResult;
        try {
            remoteResult = remoteOrderExportTemplateBackendService.find4Page(param);
        }catch (Exception e){
            LOGGER.error("find template page failed",e);
            return new Pagenation<>();
        }

        //组装
        List<OrderExportTemplateVO> list = BeanUtils.copyList(remoteResult.getList(),OrderExportTemplateVO.class) ;

        Pagenation<OrderExportTemplateVO> result = new Pagenation<>();
        result.setTotal(remoteResult.getTotal());
        result.setList(list);

        return result;
    }

    @Override
    public List<OrderExportTemplateVO> find4Select() {
        List<OrderExportTemplateDto> remoteResult;
        try {
            remoteResult = remoteOrderExportTemplateBackendService.findTemp4Select();
        } catch (Exception e) {
            LOGGER.error("find template fields failed", e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList(remoteResult, OrderExportTemplateVO.class);
    }

    @Override
    public Boolean deleteTemplate(Long tempId) {
        try {
            return remoteOrderExportTemplateBackendService.deleteById(tempId);
        }catch (Exception e){
            LOGGER.error("delete template failed",e);
            return false;
        }
    }

    @Override
    public Boolean saveTemplate(Long tempId, String tempName) {
        try {
            return remoteOrderExportTemplateBackendService.save(tempId, tempName);
        } catch (Exception e) {
            LOGGER.error("save template failed", e);
            return false;
        }
    }

    @Override
    public List<TemplateFieldVO> findTempFields(Long tempId) {
        List<TemplateFieldDto> remoteResult;
        try {
            remoteResult = remoteOrderExportTemplateBackendService.findTempFields(tempId);
        } catch (Exception e) {
            LOGGER.error("find template fields failed", e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList(remoteResult, TemplateFieldVO.class);
    }

    @Override
    public Boolean deleteTempField(Long tempFieldId) {
        try {
            return remoteOrderExportTemplateBackendService.deleteTempField(tempFieldId);
        } catch (Exception e) {
            LOGGER.error("delete template field failed", e);
            return false;
        }
    }

    @Override
    public Boolean saveTempField(TemplateFieldDto templateFieldDto) {

        try {
            return remoteOrderExportTemplateBackendService.saveTempField(templateFieldDto);
        } catch (Exception e) {
            LOGGER.error("save template field failed", e);
            return false;
        }
    }

    @Override
    public TemplateFieldVO findTempField(Long tempFieldId) {
        TemplateFieldDto remoteResult;
        try {
            remoteResult = remoteOrderExportTemplateBackendService.findTempField(tempFieldId);
        } catch (Exception e) {
            LOGGER.error("find template field failed", e);
            return null;
        }
        return BeanUtils.copy(remoteResult, TemplateFieldVO.class);
    }

    @Override
    public List<FieldVO> selectFields() {
        List<FieldDto> remoteResult;
        try {
            remoteResult = remoteOrderExportTemplateBackendService.findField4Select();
        } catch (Exception e) {
            LOGGER.error("find field for select  failed", e);
            return Collections.emptyList();
        }
        return BeanUtils.copyList(remoteResult, FieldVO.class);
    }
}
