package com.qiho.manager.biz.service.page;

import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.manager.biz.vo.page.CollPageVO;
import com.qiho.manager.biz.vo.page.CollSkinVO;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
public interface CollPageService {

    /**
     * 查询集合页列表
     *
     * @return List<CollPageVO>
     */
    List<CollPageVO> queryList();

    /**
     * 将CollPageDto转化成CollPageVO
     *
     * @param collPageDto
     * @return List<CollPageVO>
     */
    List<CollPageVO> transformCollPageVO(List<CollPageDto> collPageDto);

    /**
     * 查询集合页皮肤列表
     *
     * @return List<CollSkinVO>
     */
    List<CollSkinVO> querySkinList();

    /**
     * 保存集合页
     *
     * @param collPageDto
     * @return Integer
     */
    Integer saveCollPage(CollPageDto collPageDto);
}
