package com.qiho.manager.biz.service.region;

import com.qiho.center.api.dto.region.BaiqiRegionDto;
import com.qiho.manager.biz.vo.region.RegionVO;

import java.util.List;

/**
 * 中国省市区乡镇service
 * Author：zhanghuifeng
 * Date: Created in 16:01 2018/2/26
 */
public interface BaiqiRegionService {

    /**
     * 根据上级区域ID查询所有区域
     * @param parentId 上级区域ID
     * @return 集合
     */
    List<BaiqiRegionDto> find(Long parentId);

    /**
     * 批量修复行政区划编码
     * @param batchNum 批次号
     */
    Boolean fixAreaNum(Integer batchNum);

    /**
     * 获取行政区划代码为空的区域信息，限制1000条
     * @param regionLevel  区域级别
     * @return 集合
     */
    List<RegionVO> findNullAreaNumRegion(Integer regionLevel);

    /**
     * 更新区域编码
     * @param regionName  区域名称
     * @param areaNum     行政区划代码
     * @return boolean
     */
    Boolean updateAreaNumByRegionName(String regionName, int areaNum);

    /**
     * 根据名称和等级查询区域信息
     *
     * @param regionName  区域名称
     * @param regionLevel 区域等级
     * @return 区域信息
     */
    RegionVO findByNameAndLevel(String regionName, int regionLevel);
}
