package com.qiho.manager.biz.service.tag;

import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.manager.biz.vo.CategoryVO;
import com.qiho.manager.biz.vo.tag.TagTypeVO;

import java.util.List;

/**
 *  标签类型服务接口
 * @author chensong
 * @create 2018-03-27 09:57
 **/
public interface TagTypeService {

    /**
     * 保存标签类型
     * @param tagTypeDto
     * @param categoryIds
     * @return
     */
    String saveType(TagTypeDto tagTypeDto, List<Long> categoryIds);

    /**
     * 标签类型查询
     * @param catagoryId
     * @param typeName
     * @return
     */
    List<TagTypeVO> queryTagType(Long catagoryId, String typeName);

    /**
     * 删除标签类型
     * @param id
     * @return
     */
    Boolean deleteTagType(Long id);

    /**
     * 根据商品id获取对应的标签类型
     * @param itemId
     * @return
     */
    List<TagTypeVO> findByItemId(Long itemId);

    /**
     * 根据类型id获取已关联的类目
     * @param typeId
     * @return
     */
    List<CategoryVO> findCategoryByTypeId(Long typeId);

}
