/**
 * Project Name:qiho-manager-biz File Name:SkuPropertyNameVO.java Package Name:com.qiho.manager.biz.vo
 * Date:2017年5月19日上午11:56:39 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:SkuPropertyNameVO <br/>
 * 商品属性名称. <br/>
 * Date: 2017年5月19日 上午11:56:39 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel(value = "商品属性")
public class SkuPropertyVO {

    @ApiModelProperty(value = "属性名称ID", required = true)
    private Long                     id;

    @ApiModelProperty(value = "属性名称", required = true)
    private String                   propertyName;

    @ApiModelProperty(value = "排序值，按序号倒序排", required = true)
    private Integer                  payload;

    @ApiModelProperty(value = "属性值列表", required = true)
    private List<SkuPropertyValueVO> propertyValueList;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * propertyName.
     *
     * @return the propertyName
     */
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * propertyName.
     *
     * @param propertyName the propertyName to set
     */
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    /**
     * payload.
     *
     * @return the payload
     */
    public Integer getPayload() {
        return payload;
    }

    /**
     * payload.
     *
     * @param payload the payload to set
     */
    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    /**
     * propertyValueList.
     *
     * @return the propertyValueList
     */
    public List<SkuPropertyValueVO> getPropertyValueList() {
        return propertyValueList;
    }

    /**
     * propertyValueList.
     *
     * @param propertyValueList the propertyValueList to set
     */
    public void setPropertyValueList(List<SkuPropertyValueVO> propertyValueList) {
        this.propertyValueList = propertyValueList;
    }

}
