/**
 * Project Name:qiho-manager-biz File Name:TemplateVO.java Package Name:com.qiho.manager.biz.vo Date:2017年6月23日下午3:12:51
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * ClassName:TemplateVO <br/>
 * Date: 2017年6月23日 下午3:12:51 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("模板")
public class TemplateVO {

    @ApiModelProperty("主键")
    private Long    id;

    @ApiModelProperty("模板代码")
    private String  templateCode;

    @ApiModelProperty("模板名称")
    private String  templateName;

    @ApiModelProperty("模板内容")
    private String  templateContext;

    @ApiModelProperty("模板是否有效")
    private Boolean templateEnable;

    @ApiModelProperty("创建时间")
    private Date    gmtCreate;

    @ApiModelProperty("修改时间")
    private Date    gmtModified;

    @ApiModelProperty("短信渠道类型")
    private String    smsType;

    @ApiModelProperty("模板id")
    private String    noteTemplateId;

    @ApiModelProperty("是否支持绑定部分商家绑定")
    private int allBindSupport;

    @ApiModelProperty("是否支持绑定部分媒体绑定")
    private int appBindSupport;

    /**
     * 中台短信模版Id
     */
    private Long modelId;

    /**
     * 短信签名Id
     */
    private Long signId;

    /**
     * 绑定的商家信息 null 代表绑定全部
     */
    private List<MerchantSimpleVO> merchantList;

    @ApiModelProperty("绑定的媒体ID")
    private String relatedAppIds;

    @ApiModelProperty("绑定类型:1.全部商家;2.部分商家;3.部分媒体")
    private Integer bindType;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * templateCode.
     *
     * @return the templateCode
     */
    public String getTemplateCode() {
        return templateCode;
    }

    /**
     * templateCode.
     *
     * @param templateCode the templateCode to set
     */
    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    /**
     * templateName.
     *
     * @return the templateName
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * templateName.
     *
     * @param templateName the templateName to set
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    /**
     * templateContext.
     *
     * @return the templateContext
     */
    public String getTemplateContext() {
        return templateContext;
    }

    /**
     * templateContext.
     *
     * @param templateContext the templateContext to set
     */
    public void setTemplateContext(String templateContext) {
        this.templateContext = templateContext;
    }

    /**
     * templateEnable.
     *
     * @return the templateEnable
     */
    public Boolean getTemplateEnable() {
        return templateEnable;
    }

    /**
     * templateEnable.
     *
     * @param templateEnable the templateEnable to set
     */
    public void setTemplateEnable(Boolean templateEnable) {
        this.templateEnable = templateEnable;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getSmsType() {
        return smsType;
    }

    public void setSmsType(String smsType) {
        this.smsType = smsType;
    }

    public String getNoteTemplateId() {
        return noteTemplateId;
    }

    public void setNoteTemplateId(String noteTemplateId) {
        this.noteTemplateId = noteTemplateId;
    }

    public int getAllBindSupport() {
        return allBindSupport;
    }

    public void setAllBindSupport(int allBindSupport) {
        this.allBindSupport = allBindSupport;
    }

    public List<MerchantSimpleVO> getMerchantList() {
        return merchantList;
    }

    public void setMerchantList(List<MerchantSimpleVO> merchantList) {
        this.merchantList = merchantList;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }

    public String getRelatedAppIds() {
        return relatedAppIds;
    }

    public void setRelatedAppIds(String relatedAppIds) {
        this.relatedAppIds = relatedAppIds;
    }

    public int getAppBindSupport() {
        return appBindSupport;
    }

    public void setAppBindSupport(int appBindSupport) {
        this.appBindSupport = appBindSupport;
    }

    public Integer getBindType() {
        return bindType;
    }

    public void setBindType(Integer bindType) {
        this.bindType = bindType;
    }
}
