package com.qiho.manager.biz.vo.finance;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 充值订单信息
 * Author: zhanghuifeng
 * Date:   14:30 2017/12/21
 */
@ApiModel("充值订单信息")
public class FinanceRechargeInfoVO {

    @ApiModelProperty("充值单号")
    private Long rechargeNo;

    @ApiModelProperty("商户类型，1：商家；2：代理商")
    private Integer commercialTenantType;

    @ApiModelProperty("商户类型，1：商家；2：代理商")
    private String commercialTenantTypeValue;

    @ApiModelProperty("商户id")
    private Long commercialTenantId;

    @ApiModelProperty("现金金额")
    private BigDecimal cashSum;

    @ApiModelProperty("返点金额")
    private BigDecimal rebateSum;

    @ApiModelProperty("提交人")
    private String creator;

    @ApiModelProperty("操作人")
    private String operator;

    /**
     * 状态 @see BaiqiFinanceRechargeStatusEnum
     */
    @ApiModelProperty("状态")
    private Integer state;

    @ApiModelProperty("状态值")
    private String stateValue;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("商户名称")
    private String commercialTenantName;

    @ApiModelProperty("商户联系人")
    private String commercialTenantOwner;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;

    public Long getRechargeNo() {
        return rechargeNo;
    }

    public void setRechargeNo(Long rechargeNo) {
        this.rechargeNo = rechargeNo;
    }

    public Integer getCommercialTenantType() {
        return commercialTenantType;
    }

    public void setCommercialTenantType(Integer commercialTenantType) {
        this.commercialTenantType = commercialTenantType;
    }

    public String getCommercialTenantTypeValue() {
        return commercialTenantTypeValue;
    }

    public void setCommercialTenantTypeValue(String commercialTenantTypeValue) {
        this.commercialTenantTypeValue = commercialTenantTypeValue;
    }

    public Long getCommercialTenantId() {
        return commercialTenantId;
    }

    public void setCommercialTenantId(Long commercialTenantId) {
        this.commercialTenantId = commercialTenantId;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getStateValue() {
        return stateValue;
    }

    public void setStateValue(String stateValue) {
        this.stateValue = stateValue;
    }

    public String getCommercialTenantName() {
        return commercialTenantName;
    }

    public void setCommercialTenantName(String commercialTenantName) {
        this.commercialTenantName = commercialTenantName;
    }

    public String getCommercialTenantOwner() {
        return commercialTenantOwner;
    }

    public void setCommercialTenantOwner(String commercialTenantOwner) {
        this.commercialTenantOwner = commercialTenantOwner;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public BigDecimal getCashSum() {
        return cashSum;
    }

    public void setCashSum(BigDecimal cashSum) {
        this.cashSum = cashSum;
    }

    public BigDecimal getRebateSum() {
        return rebateSum;
    }

    public void setRebateSum(BigDecimal rebateSum) {
        this.rebateSum = rebateSum;
    }
}
