package com.qiho.manager.biz.vo.merchant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author peanut.huang
 * @date 2018/1/2.
 */
@ApiModel("商家广告VO")
public class MerchantAdvertVO {

    /**
     * 商家id
     */
    @ApiModelProperty("商家id")
    private Long merchantId;

    /**
     * 商家名称
     */
    @ApiModelProperty("商家名称")
    private String merchantName;

    /**
     * 广告主id
     */
    @ApiModelProperty("广告主id")
    private Long advertId;

    /**
     * 广告主名称
     */
    @ApiModelProperty("广告主名称")
    private String advertName;

    /**
     * 广告消耗
     */
    @ApiModelProperty("广告消耗")
    private String advertConsume;

    /**
     * 商家是否已关联
     */
    @ApiModelProperty("商家是否与广告主关联")
    private Boolean linked;


    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertConsume() {
        return advertConsume;
    }

    public void setAdvertConsume(String advertConsume) {
        this.advertConsume = advertConsume;
    }

    public Boolean getLinked() {
        return linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }
}
