package com.qiho.manager.biz.vo.warning;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 库存预警前端展示类
 * Created by weny.cai on 2018/1/12.
 */
@ApiModel("库存预警")
public class WarningVo {

    @ApiModelProperty("id主键")
    private Long id;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("sku名称，注：规格的组合")
    private String skuName;

    @ApiModelProperty("告警状态,0=预警,1=缺货")
    private String warnStatus;

    @ApiModelProperty("实际库存")
    private Long stock;

    @ApiModelProperty("建议库存")
    private Long suggestStock;

    @ApiModelProperty("平均销量")
    private Integer avgSaleStock;

    @ApiModelProperty("预警时间")
    private String gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getWarnStatus() {
        return warnStatus;
    }

    public void setWarnStatus(String warnStatus) {
        this.warnStatus = warnStatus;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getSuggestStock() {
        return suggestStock;
    }

    public void setSuggestStock(Long suggestStock) {
        this.suggestStock = suggestStock;
    }

    public Integer getAvgSaleStock() {
        return avgSaleStock;
    }

    public void setAvgSaleStock(Integer avgSaleStock) {
        this.avgSaleStock = avgSaleStock;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
