/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
@Scope(value="prototype")
public class BaseExportRunnable
implements ServletContextAware {
    private ServletContext servletContext;
    protected Joiner joiner = Joiner.on((String)",").useForNull("");
    @Resource(name="stringRedisTemplate")
    protected StringRedisTemplate redisTemplate;
    protected static final String SEPARATOR = "/";

    protected Map<String, Object> init(File file, Long taskId) {
        return this.init(file, taskId, CacheConstantseEnum.EXPORT_ORDER);
    }

    protected Map<String, Object> init(File file, Long taskId, CacheConstantseEnum constantseEnum) {
        String key = constantseEnum.getCacheKey((Object)taskId);
        this.redisTemplate.opsForHash().put((Object)key, (Object)"successCount", (Object)"0");
        this.redisTemplate.opsForHash().put((Object)key, (Object)"success", (Object)"false");
        this.redisTemplate.opsForHash().put((Object)key, (Object)"url", (Object)"");
        this.redisTemplate.opsForHash().put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u4e2d");
        HashMap info = Maps.newHashMap();
        info.put("taskId", taskId.toString());
        info.put("fileName", file.getName());
        return info;
    }

    protected File getFile(String filePath) {
        String webRootDir = this.servletContext.getRealPath(SEPARATOR);
        File userDir = new File(webRootDir, SEPARATOR + filePath);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis()).append(".csv");
        return new File(userDir, sb.toString());
    }

    protected File getFile2(String filePath) {
        String webRootDir = this.servletContext.getRealPath(SEPARATOR);
        File userDir = new File(webRootDir, SEPARATOR + filePath);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis()).append(".xlsx");
        return new File(userDir, sb.toString());
    }

    protected String useForNull(Object obj) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        if (Objects.equal(null, (Object)obj)) {
            builder.append("");
        } else {
            builder.append(obj.toString());
        }
        builder.append("\"");
        return builder.toString();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

