/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.remoteservice.blackList.RemoteBaiqiBlackListService;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListService;
import com.qiho.manager.biz.params.BlackExportParam;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BlackListExportRunnable
extends BaseExportRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackListExportRunnable.class);
    private static final int ORDER_EXPORT_MAX = 5000;
    @Autowired
    private RemoteBlackListService remoteBlackListService;
    private BaiqiBlackListQueryParam params;
    private String filePath = "blackList/";
    private File file;
    private Long taskId = System.currentTimeMillis();
    @Autowired
    private RemoteBaiqiBlackListService remoteBaiqiBlackListService;

    public Map<String, Object> init() {
        this.file = super.getFile2(this.filePath);
        return super.init(this.file, this.taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exportCount = this.remoteBaiqiBlackListService.queryBlackListPageCount(this.params);
        int batch = this.getBatchs(exportCount);
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        Workbook workbook = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            ArrayList exportList = Lists.newArrayList();
            for (int i = 0; i < batch; ++i) {
                this.params.setOffset(Integer.valueOf(i * 5000));
                PagenationDto result = this.remoteBaiqiBlackListService.queryBlackListPage(this.params);
                List<BlackExportParam> list = this.transferExcelEntity((PagenationDto<BaiqiBlackListDto>)result);
                exportList.addAll(list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), BlackExportParam.class, (Collection)exportList);
            workbook.write((OutputStream)outputStream);
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/x-msdownload;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)LOGGER, (String)"black Export error msg={}", (Object[])new Object[]{e});
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            ExcelExportUtil.closeExportBigExcel();
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                AppLogUtil.warn((Logger)LOGGER, (String)"file delete error or file not exists");
            }
        }
    }

    private List<BlackExportParam> transferExcelEntity(PagenationDto<BaiqiBlackListDto> result) {
        ArrayList list = Lists.newArrayList();
        for (BaiqiBlackListDto dto : result.getList()) {
            BlackExportParam ordersExport = (BlackExportParam)BeanUtils.copy((Object)dto, BlackExportParam.class);
            ordersExport.setDealType(dto.getSourceType().getDesc());
            list.add(ordersExport);
        }
        return list;
    }

    private int getBatchs(int total) {
        return total % 5000 == 0 ? total / 5000 : total / 5000 + 1;
    }

    public BaiqiBlackListQueryParam getParams() {
        return this.params;
    }

    public void setParams(BaiqiBlackListQueryParam params) {
        params.setMax(Integer.valueOf(5000));
        params.setOffset(Integer.valueOf(0));
        this.params = params;
    }
}

