/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.api.remoteservice.ordertmp.RemoteOrderTmpService;
import com.qiho.manager.biz.params.OrdersTempExportParam;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderTmpExportRunnable
extends BaseExportRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpExportRunnable.class);
    private static final int ORDER_EXPORT_MAX = 1000;
    @Autowired
    private RemoteOrderTmpService remoteOrderTmpService;
    private OrderTmpPageParam pageParam;
    private File file;
    private String filePath = "orders/";
    private Long taskId = System.currentTimeMillis();

    public Map<String, Object> init() {
        this.file = super.getFile2(this.filePath);
        return super.init(this.file, this.taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count = this.remoteOrderTmpService.countPageQuery(this.pageParam);
        int batch = this.getBatchs(count);
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        Workbook workbook = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            ArrayList exportList = Lists.newArrayList();
            for (int i = 0; i < batch; ++i) {
                this.pageParam.setOffset(Integer.valueOf(i * 1000));
                PagenationDto result = this.remoteOrderTmpService.queryOrderTmpPage(this.pageParam);
                List<OrdersTempExportParam> list = this.transferExcelEntity((PagenationDto<OrderTmpDetailDto>)result);
                exportList.addAll(list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), OrdersTempExportParam.class, (Collection)exportList);
            workbook.write((OutputStream)outputStream);
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/x-msdownload;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("orders Export error msg={}", (Throwable)e);
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            ExcelExportUtil.closeExportBigExcel();
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                LOGGER.warn("file delete error or file not exists");
            }
        }
    }

    private List<OrdersTempExportParam> transferExcelEntity(PagenationDto<OrderTmpDetailDto> result) {
        ArrayList list = Lists.newArrayList();
        for (OrderTmpDetailDto dto : result.getList()) {
            OrdersTempExportParam ordersExport = (OrdersTempExportParam)BeanUtils.copy((Object)dto, OrdersTempExportParam.class);
            ordersExport.setOrderAmt((double)dto.getOrderAmt().intValue() / 100.0);
            if (dto.getDeliveryEnum() == null) {
                ordersExport.setDelivery("");
            } else {
                ordersExport.setDelivery(dto.getDeliveryEnum().getDesc());
            }
            ordersExport.setOrderStatus(dto.getOrderStatusEnum().getDesc());
            ordersExport.setSellingPrice((double)dto.getSellingPrice().intValue() / 100.0);
            ordersExport.setAnticheatRules(String.join((CharSequence)",", dto.getAnticheatRules()));
            list.add(ordersExport);
        }
        return list;
    }

    private int getBatchs(int total) {
        return total % 1000 == 0 ? total / 1000 : total / 1000 + 1;
    }

    public OrderTmpPageParam getPageParam() {
        return this.pageParam;
    }

    public void setPageParam(OrderTmpPageParam pageParam) {
        pageParam.setMax(Integer.valueOf(1000));
        pageParam.setOffset(Integer.valueOf(0));
        this.pageParam = pageParam;
    }
}

