/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Deprecated
public class WdtErpOrderExportRunnable
extends BaseExportRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WdtErpOrderExportRunnable.class);
    private static final int ORDER_EXPORT_MAX = 1000;
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;
    private ErpOrderPageParams params;
    private String[] wdtColnums = new String[]{"\u539f\u59cb\u5355\u53f7", "\u5546\u5bb6\u7f16\u7801", "\u8d27\u54c1\u6570\u91cf", "\u7f51\u540d", "\u6536\u4ef6\u4eba", "\u624b\u673a", "\u7701", "\u5e02", "\u533a", "\u5730\u5740", "\u5e94\u6536\u5408\u8ba1", "\u8d27\u54c1\u603b\u4ef7", "\u5e97\u94fa\u540d\u79f0", "\u8ba2\u5355\u7c7b\u578b", "\u53d1\u8d27\u65b9\u5f0f"};
    private String[] edbColnums = new String[]{"\u8ba2\u5355\u53f7", "\u4ea7\u54c1\u6761\u7801", "\u8ba2\u5355\u72b6\u6001", "\u4e70\u5bb6id", "\u5b50\u8ba2\u5355\u7f16\u53f7", "\u4e70\u5bb6\u6635\u79f0", "\u5546\u54c1\u540d\u79f0", "\u4ea7\u54c1\u89c4\u683c", "\u5546\u54c1\u5355\u4ef7", "\u5546\u54c1\u6570\u91cf", "\u5546\u54c1\u603b\u4ef7", "\u8fd0\u8d39", "\u8d2d\u4e70\u4f18\u60e0\u4fe1\u606f", "\u603b\u91d1\u989d", "\u4e70\u5bb6\u8d2d\u4e70\u9644\u8a00", "\u6536\u8d27\u4eba\u59d3\u540d", "\u6536\u8d27\u5730\u5740-\u7701\u5e02", "\u6536\u8d27\u5730\u5740-\u8857\u9053\u5730\u5740", "\u90ae\u7f16", "\u6536\u8d27\u4eba\u624b\u673a", "\u6536\u8d27\u4eba\u7535\u8bdd", "\u4e70\u5bb6\u9009\u62e9\u8fd0\u9001\u65b9\u5f0f", "\u5356\u5bb6\u5907\u5fd8\u5185\u5bb9", "\u8ba2\u5355\u521b\u5efa\u65f6\u95f4", "\u4ed8\u6b3e\u65f6\u95f4", "\u7269\u6d41\u516c\u53f8", "\u7269\u6d41\u5355\u53f7", "\u53d1\u8d27\u9644\u8a00", "\u53d1\u7968\u62ac\u5934", "\u7535\u5b50\u90ae\u4ef6"};
    private File file;
    private String filePath = "orders/";
    private Long taskId = new Date().getTime();
    private static final String DIRECTLY_CITY = "\u5e02";

    public Map<String, Object> init() {
        this.file = super.getFile(this.filePath);
        return super.init(this.file, this.taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CharSink charSink = Files.asCharSink((File)this.file, (Charset)Charset.forName("GBK"), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
        DubboResult exportCount = this.remoteErpOrderService.findErpOrderPageCount(this.params);
        int batch = this.getBatchs((Integer)exportCount.getResult());
        ArrayList headers = Lists.newArrayList();
        Object trsform = null;
        if (ErpManufacturerType.EDB.getCode().equals(this.params.getErpType())) {
            trsform = new EdbOrderSnapshotToString();
            headers.add(this.joiner.join((Object[])this.edbColnums));
        } else {
            trsform = new OrderSnapshotToString();
            headers.add(this.joiner.join((Object[])this.wdtColnums));
        }
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        try {
            charSink.writeLines((Iterable)headers);
            for (int i = 0; i < batch; ++i) {
                this.params.setOffset(Integer.valueOf(i * 1000));
                DubboResult result = this.remoteErpOrderService.findWdtExportErpOrder(this.params);
                List list = Lists.transform((List)((List)result.getResult()), (Function)trsform);
                charSink.writeLines((Iterable)list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/csv;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)LOGGER, (String)"orders Export error msg={}", (Object[])new Object[]{e});
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                AppLogUtil.warn((Logger)LOGGER, (String)"file delete error or file not exists");
            }
        }
    }

    private int getBatchs(int total) {
        return total % 1000 == 0 ? total / 1000 : total / 1000 + 1;
    }

    public ErpOrderPageParams getParams() {
        return this.params;
    }

    public void setParams(ErpOrderPageParams params) {
        params.setMax(Integer.valueOf(1000));
        params.setOffset(Integer.valueOf(0));
        this.params = params;
    }

    private class OrderSnapshotToString
    implements Function<OrderSnapshotDto, String> {
        private OrderSnapshotToString() {
        }

        public String apply(OrderSnapshotDto input) {
            ArrayList row = Lists.newArrayList();
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getErpId()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getSkuNo()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getQuantity()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getConsumerName()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getConsumerName()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getMobile()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getProvince()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getCity()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getDistrict()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getAddress()));
            row.add(WdtErpOrderExportRunnable.this.useForNull((double)input.getOrderAmt().intValue() / 100.0));
            row.add(WdtErpOrderExportRunnable.this.useForNull((double)input.getOrderAmt().intValue() / 100.0));
            row.add(WdtErpOrderExportRunnable.this.useForNull("\u5947\u8d27"));
            if (PayTypeEnum.COD.getCode().equals(input.getPayType())) {
                row.add("\u8d27\u5230\u4ed8\u6b3e");
                row.add("\u8d27\u5230\u4ed8\u6b3e");
            } else {
                row.add("\u6b3e\u5230\u53d1\u8d27");
                row.add("\u6b3e\u5230\u53d1\u8d27");
            }
            return WdtErpOrderExportRunnable.this.joiner.join((Iterable)row);
        }
    }

    private class EdbOrderSnapshotToString
    implements Function<OrderSnapshotDto, String> {
        private EdbOrderSnapshotToString() {
        }

        public String apply(OrderSnapshotDto input) {
            ArrayList row = Lists.newArrayList();
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getErpId()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getSkuNo()));
            if (PayTypeEnum.COD.getCode().equals(input.getPayType())) {
                row.add("\u8d27\u5230\u4ed8\u6b3e");
            } else {
                row.add("\u4e70\u5bb6\u5df2\u4ed8\u6b3e\uff0c\u7b49\u5f85\u5356\u5bb6\u53d1\u8d27");
            }
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getConsumerName()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getErpId()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getConsumerName()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getItemName()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getSellingPrice()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getQuantity()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getOrderAmt()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getOrderAmt()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getMessage()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getConsumerName()));
            if (input.getProvince().indexOf(WdtErpOrderExportRunnable.DIRECTLY_CITY) > -1) {
                if (StringUtils.isNotBlank((String)input.getDistrict())) {
                    row.add(WdtErpOrderExportRunnable.this.useForNull(input.getCity() + input.getDistrict()));
                } else {
                    row.add(WdtErpOrderExportRunnable.this.useForNull(input.getProvince() + input.getCity()));
                }
            } else {
                row.add(WdtErpOrderExportRunnable.this.useForNull(input.getProvince() + input.getCity() + input.getDistrict()));
            }
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getAddress()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(input.getMobile()));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(DateUtils.getSecondStr((Date)input.getGmtCreate())));
            if (PayTypeEnum.COD.getCode().equals(input.getPayType())) {
                row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            } else {
                row.add(WdtErpOrderExportRunnable.this.useForNull(DateUtils.getSecondStr((Date)input.getGmtModified())));
            }
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            row.add(WdtErpOrderExportRunnable.this.useForNull(null));
            return WdtErpOrderExportRunnable.this.joiner.join((Iterable)row);
        }
    }
}

