/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.itemtaskhandler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.region.BaiqiRegionDto;
import com.qiho.center.api.enums.item.ItemEvaluateTypeEnum;
import com.qiho.center.api.params.item.BatchImportItemEvaluateParams;
import com.qiho.center.api.remoteservice.item.RemoteItemEvaluateBackendService;
import com.qiho.manager.biz.runnable.AbstractItemEvaluateHandler;
import com.qiho.manager.biz.service.region.BaiqiRegionService;
import com.qiho.manager.biz.vo.region.RegionVO;
import com.qiho.manager.common.util.MobileUtil;
import com.qiho.manager.common.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemEvaluateHandler
implements AbstractItemEvaluateHandler<BatchImportItemEvaluateParams> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemEvaluateHandler.class);
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
    @Resource
    private RemoteItemEvaluateBackendService remoteItemEvaluateBackendService;
    @Resource
    private BaiqiRegionService baiqiRegionService;

    @Override
    public BatchImportItemEvaluateParams transform(String row, Long itemId) {
        List line = this.splitter.splitToList((CharSequence)row);
        return line.size() < 6 ? null : this.getBatchImportItemEvaluateParams(line, itemId);
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchImportItemEvaluateParams> list) {
        return this.remoteItemEvaluateBackendService.batchImportItemEval(cacheKey, list);
    }

    private BatchImportItemEvaluateParams getBatchImportItemEvaluateParams(List<String> line, Long itemId) {
        BatchImportItemEvaluateParams params = new BatchImportItemEvaluateParams();
        try {
            AdminDto admin = RequestTool.getAdmin();
            params.setOperator(admin != null ? admin.getAccount() : "");
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7ba1\u7406\u5458\u5f02\u5e38, params: {} ", (Object)params, (Object)e);
            params.setOperator("");
        }
        try {
            Integer maxSort = this.remoteItemEvaluateBackendService.queryMaxSort(itemId);
            params.setSort(Integer.valueOf(maxSort == null ? 0 : maxSort + 1));
            RegionVO regionVO = this.baiqiRegionService.findByNameAndLevel(line.get(3), 1);
            if (null != regionVO && regionVO.getRegionName().endsWith("\u5e02")) {
                params.setRegionName(this.subRegionSuffix(line.get(3)));
            } else {
                params.setRegionName(this.subRegionSuffix(line.get(3)) + this.subRegionSuffix(line.get(4)));
            }
            params.setItemId(itemId);
            params.setUserName(line.get(0));
            params.setMobile(line.get(1));
            params.setRating(Integer.valueOf(this.parseRating(line.get(2))));
            params.setProvince(this.subRegionSuffix(line.get(3)));
            params.setCity(this.subRegionSuffix(line.get(4)));
            params.setEvaluateContent(line.get(5));
            params.setEvaluateType(ItemEvaluateTypeEnum.EXCEL_IMPORT_EVAL.getCode());
        }
        catch (Exception e) {
            LOGGER.info("\u89e3\u6790Excel\u5185\u5bb9\u51fa\u9519, line={}", line, (Object)e);
            return null;
        }
        return this.checkParam(params) ? params : null;
    }

    private int parseRating(String num) {
        return StringUtils.isNumeric((CharSequence)num) ? Integer.parseInt(num) : 0;
    }

    private String subRegionSuffix(String regionStr) {
        if (regionStr.endsWith("\u7701") || regionStr.endsWith("\u5e02")) {
            return regionStr.substring(0, regionStr.length() - 1);
        }
        if (regionStr.endsWith("\u81ea\u6cbb\u533a")) {
            return regionStr.substring(0, 2);
        }
        return regionStr;
    }

    private boolean checkParam(BatchImportItemEvaluateParams param) {
        if (null == param) {
            return false;
        }
        String userName = param.getUserName();
        if (!StringUtil.isFullChinese((String)userName)) {
            return false;
        }
        if (userName.length() < 2 || userName.length() > 10) {
            return false;
        }
        if (!MobileUtil.validPhoneNum((String)param.getMobile())) {
            return false;
        }
        Integer rating = param.getRating();
        if (null == rating || rating <= 0 || rating > 5) {
            return false;
        }
        RegionVO provinceRegionVO = this.baiqiRegionService.findByNameAndLevel(param.getProvince(), 1);
        if (null == provinceRegionVO) {
            return false;
        }
        if (!provinceRegionVO.getRegionName().endsWith("\u5e02") && StringUtils.isNotEmpty((CharSequence)param.getCity())) {
            RegionVO cityRegionVO = this.baiqiRegionService.findByNameAndLevel(param.getCity(), 2);
            if (null == cityRegionVO) {
                return false;
            }
            List<BaiqiRegionDto> regionDtoList = this.baiqiRegionService.find(provinceRegionVO.getId());
            List regionStrList = regionDtoList.stream().map(BaiqiRegionDto::getRegionName).collect(Collectors.toList());
            if (!regionStrList.contains(cityRegionVO.getRegionName())) {
                return false;
            }
        }
        return param.getEvaluateContent().length() <= 50;
    }
}

