/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;
import com.qiho.center.api.remoteservice.blackList.RemoteBaiqiBlackListService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlackListHandler
implements AbstractOrderHandler<BlackListBatchDealParam> {
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings().limit(3);
    Pattern wirteSpacePattern = Pattern.compile("\\s*|\t|\r|\n");
    @Autowired
    private RemoteBaiqiBlackListService remoteBaiqiBlackListService;

    @Override
    public BlackListBatchDealParam transform(String row, String status) {
        BlackListBatchDealParam params = new BlackListBatchDealParam();
        List list = this.splitter.splitToList((CharSequence)row);
        if (CollectionUtils.isEmpty((Collection)list) || StringUtils.isBlank((String)((String)list.get(0)))) {
            return null;
        }
        String value = (String)list.get(0);
        if (value != null) {
            if (StringUtils.equals((String)value, (String)"\u624b\u673a\u53f7")) {
                return null;
            }
        } else {
            return null;
        }
        Matcher matcher = this.wirteSpacePattern.matcher(value);
        value = matcher.replaceAll("");
        params.setBkValue(value);
        if (list.size() > 1) {
            params.setRemarks((String)list.get(1));
        }
        return params;
    }

    @Override
    public BlackListBatchDealParam transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<BlackListBatchDealParam> list) {
        throw new UnsupportedOperationException("\u5fc5\u987b\u6307\u5b9a\u9ed1\u540d\u5355\u7c7b\u578b\u7b49\u5176\u4ed6\u53c2\u6570");
    }

    @Override
    public Integer exeTask(String cacheKey, List<BlackListBatchDealParam> list, JSONObject extraParams) {
        Long merchantId = extraParams.getLong("merchantId");
        String name = RequestTool.getAdmin().getName();
        for (BlackListBatchDealParam params : list) {
            params.setMerchantId(merchantId);
            params.setOperator(name);
        }
        return this.remoteBaiqiBlackListService.batchAddBlackList(cacheKey, list, merchantId, name);
    }
}

