/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpOrderDeliverToSuccessHandler
implements AbstractOrderHandler<BatchResolveErpDeliverParams> {
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;
    @Resource
    private RemoteLogisticsService remoteLogisticsService;

    @Override
    public BatchResolveErpDeliverParams transform(String row, String status) {
        BatchResolveErpDeliverParams params = new BatchResolveErpDeliverParams();
        List line = this.splitter.splitToList((CharSequence)row);
        if (line.size() < 2) {
            return null;
        }
        params.setErpId((String)line.get(0));
        params.setExpressCode((String)line.get(1));
        params.setDealResult(Integer.valueOf(1));
        return params;
    }

    @Override
    public BatchResolveErpDeliverParams transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list) {
        throw new UnsupportedOperationException("\u5fc5\u987b\u6307\u5b9a\u7269\u6d41\u516c\u53f8\u7b49\u5176\u4ed6\u53c2\u6570");
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list, JSONObject extraParams) {
        String express = extraParams.getString("express");
        LogisticsDto logisticsDto = this.remoteLogisticsService.findByCode(express);
        if (logisticsDto == null) {
            throw new QihoException("\u5fc5\u987b\u6307\u5b9a\u6709\u6548\u7684\u5feb\u9012\u516c\u53f8");
        }
        String logisticCode = logisticsDto.getLogisticsCode();
        String logisticsName = logisticsDto.getLogisticsName();
        for (BatchResolveErpDeliverParams params : list) {
            params.setBaiqiLogisticsCode(logisticCode);
            params.setBaiqiLogisticsName(logisticsName);
        }
        DubboResult result = this.remoteErpOrderService.batchResolveErpDeliver(cacheKey, list);
        return (Integer)result.getResult();
    }
}

